/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.applaunch.config.core;

import io.leangen.geantyref.TypeToken;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.applaunch.config.core.Config;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.loader.ConfigurationLoader;
import org.spongepowered.configurate.objectmapping.ObjectMapper;
import org.spongepowered.configurate.serialize.SerializationException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ConfigHandle<T extends Config> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final NodePath VERSION_PATH = NodePath.path("version");
    private static final String VERSION_COMMENT = "Active configuration version\nThis has no relation to the current Sponge version, and will be updated automatically\nManual changes may cause unpredictable results.";
    private static boolean saveSuppressed = true;
    private static final Set<ConfigHandle<?>> saveQueue = ConcurrentHashMap.newKeySet();
    protected final @Nullable ConfigurationLoader<? extends CommentedConfigurationNode> loader;
    protected final ObjectMapper.Mutable<T> mapper;
    protected final T instance;
    protected @MonotonicNonNull CommentedConfigurationNode node;

    public static void setSaveSuppressed(boolean suppressed) {
        saveSuppressed = suppressed;
        if (!suppressed && !saveQueue.isEmpty()) {
            Iterator<ConfigHandle<?>> it = saveQueue.iterator();
            while (it.hasNext()) {
                try {
                    it.next().doSave();
                }
                catch (ConfigurateException ex) {
                    LOGGER.error("Unable to save a Sponge configuration!", (Throwable)ex);
                }
                it.remove();
            }
        }
    }

    private static <T> ObjectMapper.Mutable<T> mutableMapper(T instance) {
        try {
            ObjectMapper<?> mapper = SpongeConfigs.OBJECT_MAPPERS.get(instance.getClass());
            if (mapper instanceof ObjectMapper.Mutable) {
                return (ObjectMapper.Mutable)mapper;
            }
        }
        catch (SerializationException ex) {
            throw new AssertionError((Object)ex);
        }
        throw new AssertionError((Object)("Object mapper for " + instance + " was not mutable"));
    }

    protected ConfigHandle(T instance) {
        this.mapper = ConfigHandle.mutableMapper(instance);
        this.instance = instance;
        this.loader = null;
    }

    protected ConfigHandle(T instance, @Nullable ConfigurationLoader<? extends CommentedConfigurationNode> loader) {
        this.mapper = ConfigHandle.mutableMapper(instance);
        this.instance = instance;
        this.loader = loader;
    }

    public boolean isAttached() {
        return this.loader != null;
    }

    public T get() {
        return this.instance;
    }

    public CompletableFuture<T> updateAndSave(UnaryOperator<T> updater) {
        Config updated = (Config)Objects.requireNonNull(updater, "updater").apply(this.instance);
        return ConfigHandle.asyncFailableFuture(() -> {
            this.save();
            return updated;
        }, ForkJoinPool.commonPool());
    }

    void load() throws ConfigurateException {
        if (this.loader == null) {
            return;
        }
        this.node = this.loader.load();
        this.doVersionUpdate();
        this.mapper.load(this.instance, this.node);
        this.doSave();
    }

    protected final void doVersionUpdate() throws ConfigurateException {
        boolean wasEmpty = this.node.empty();
        CommentedConfigurationNode versionNode = (CommentedConfigurationNode)this.node.node((Iterable)VERSION_PATH);
        int existingVersion = versionNode.getInt(-1);
        this.instance.getTransformation().apply(this.node);
        int newVersion = versionNode.getInt(-1);
        if (!wasEmpty && newVersion > existingVersion) {
            LOGGER.info("Updated {} from version {} to {}", (Object)this.instance, (Object)existingVersion, (Object)newVersion);
        }
        versionNode.commentIfAbsent(VERSION_COMMENT);
        ((CommentedConfigurationNode)this.node.node((Iterable)VERSION_PATH)).set(versionNode);
    }

    public void reload() throws ConfigurateException {
        this.load();
    }

    public final void save() {
        if (saveSuppressed) {
            saveQueue.add(this);
        } else {
            try {
                this.doSave();
            }
            catch (ConfigurateException ex) {
                LOGGER.error("Unable to save configuration to {}", (Object)this.loader, (Object)ex);
            }
        }
    }

    protected void doSave() throws ConfigurateException {
        if (this.loader == null) {
            return;
        }
        if (this.node == null) {
            this.node = (CommentedConfigurationNode)this.loader.createNode();
        }
        this.mapper.save(this.instance, this.node);
        this.loader.save(this.node);
    }

    private @Nullable CommentedConfigurationNode getSetting(String key) {
        if (key.equalsIgnoreCase("config-enabled")) {
            return (CommentedConfigurationNode)this.node.node(new Object[]{key});
        }
        if (!key.contains(".") || key.indexOf(46) == key.length() - 1) {
            return null;
        }
        CommentedConfigurationNode node = this.node;
        String[] split = key.split("\\.");
        return (CommentedConfigurationNode)node.node(split);
    }

    public CompletableFuture<CommentedConfigurationNode> updateSetting(String key, Object value) {
        return ConfigHandle.asyncFailableFuture(() -> {
            CommentedConfigurationNode upd = this.getSetting(key);
            upd.set(value);
            this.mapper.load(this.instance, this.node);
            this.save();
            return upd;
        }, ForkJoinPool.commonPool());
    }

    public <V> CompletableFuture<CommentedConfigurationNode> updateSetting(String key, V value, TypeToken<V> token) {
        return ConfigHandle.asyncFailableFuture(() -> {
            CommentedConfigurationNode upd = this.getSetting(key);
            upd.set(token, value);
            this.mapper.load(this.instance, this.node);
            this.save();
            return upd;
        }, ForkJoinPool.commonPool());
    }

    private static <T> CompletableFuture<T> asyncFailableFuture(Callable<T> action, Executor executor) {
        CompletableFuture future = new CompletableFuture();
        executor.execute(() -> {
            try {
                future.complete(action.call());
            }
            catch (Exception ex) {
                future.completeExceptionally(ex);
            }
        });
        return future;
    }

    public ConfigurationNode getNode() {
        return this.node;
    }
}

