/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.bridge.entity.player;

import java.util.Collection;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.minecraft.block.BlockState;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldType;
import net.minecraft.world.dimension.DimensionType;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.type.SkinPart;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.common.bridge.network.NetworkManagerBridge;
import org.spongepowered.common.entity.player.ClientType;
import org.spongepowered.common.world.border.PlayerOwnBorderListener;
import org.spongepowered.common.world.dimension.SpongeDimensionType;

public interface ServerPlayerEntityBridge {
    default public ClientType bridge$getClientType() {
        ServerPlayerEntity mPlayer = (ServerPlayerEntity)this;
        if (mPlayer.connection == null) {
            return ClientType.VANILLA;
        }
        return ((NetworkManagerBridge)mPlayer.connection.netManager).bridge$getClientType();
    }

    public int bridge$getViewDistance();

    public @Nullable User bridge$getUserObject();

    public void bridge$sendBlockChange(BlockPos var1, BlockState var2);

    public void bridge$initScoreboard();

    public void bridge$removeScoreboardOnRespawn();

    public void bridge$setScoreboardOnRespawn(Scoreboard var1);

    public void bridge$restorePacketItem(Hand var1);

    public void bridge$setPacketItem(ItemStack var1);

    public void bridge$refreshExp();

    public PlayerOwnBorderListener bridge$getWorldBorderListener();

    public void bridge$setHealthScale(double var1);

    public double bridge$getHealthScale();

    public float bridge$getInternalScaledHealth();

    public boolean bridge$isHealthScaled();

    public void bridge$refreshScaledHealth();

    public void bridge$injectScaledHealth(Collection<IAttributeInstance> var1);

    public boolean bridge$hasForcedGamemodeOverridePermission();

    public void bridge$setContainerDisplay(Component var1);

    public Scoreboard bridge$getScoreboard();

    public void bridge$replaceScoreboard(@Nullable Scoreboard var1);

    public Set<SkinPart> bridge$getSkinParts();

    public @Nullable User bridge$getUser();

    public @Nullable ITextComponent bridge$getConnectionMessageToSend();

    public void bridge$setConnectionMessageToSend(ITextComponent var1);

    default public void bridge$sendDimensionData(NetworkManager manager, DimensionType dimensionType) {
    }

    default public void bridge$sendChangeDimension(DimensionType type, long hashedSeed, WorldType generator, GameType gameType) {
        ((ServerPlayerEntity)this).connection.sendPacket((IPacket)new SRespawnPacket(type, hashedSeed, generator, gameType));
    }

    default public void bridge$sendViewerEnvironment(SpongeDimensionType dimensionType) {
    }

    public boolean bridge$kick(Component var1);
}

