/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.brigadier;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.kyori.adventure.text.Component;
import net.minecraft.util.ResourceLocation;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.ArgumentReader;
import org.spongepowered.common.command.brigadier.SpongeImmutableArgumentReader;

public final class SpongeStringReader
extends StringReader
implements ArgumentReader.Mutable {
    private static final char SYNTAX_QUOTE = '\"';

    public SpongeStringReader(String string) {
        super(string);
    }

    public SpongeStringReader(StringReader other) {
        super(other);
    }

    public void unskipWhitespace() {
        if (this.getRemainingLength() >= 0 && this.peek(-1) == ' ') {
            this.setCursor(this.getCursor() - 1);
        }
    }

    @Override
    public @NonNull String getInput() {
        return this.getString();
    }

    @Override
    public char peekCharacter() {
        if (this.canRead()) {
            char read = this.read();
            this.setCursor(this.getCursor() - 1);
            return read;
        }
        throw new IllegalStateException("Cannot get character when at the end of the string.");
    }

    @Override
    public char parseChar() {
        return this.read();
    }

    @Override
    public int parseInt() throws ArgumentParseException {
        try {
            return this.readInt();
        }
        catch (CommandSyntaxException e) {
            throw new ArgumentParseException((Component)Component.text((String)"Could not parse an integer"), (Throwable)e, this.getString(), this.getCursor());
        }
    }

    @Override
    public double parseDouble() throws ArgumentParseException {
        try {
            return this.readDouble();
        }
        catch (CommandSyntaxException e) {
            throw new ArgumentParseException((Component)Component.text((String)"Could not parse a double"), (Throwable)e, this.getString(), this.getCursor());
        }
    }

    @Override
    public float parseFloat() throws ArgumentParseException {
        try {
            return this.readFloat();
        }
        catch (CommandSyntaxException e) {
            throw new ArgumentParseException((Component)Component.text((String)"Could not parse a float"), (Throwable)e, this.getString(), this.getCursor());
        }
    }

    @Override
    public ResourceKey parseResourceKey() throws ArgumentParseException {
        return this.readResourceLocation(null);
    }

    @Override
    public ResourceKey parseResourceKey(@NonNull String defaultNamespace) throws ArgumentParseException {
        return this.readResourceLocation(defaultNamespace);
    }

    @Override
    public @NonNull String parseUnquotedString() {
        int start = this.getCursor();
        while (this.canRead() && !Character.isWhitespace(this.peek())) {
            this.skip();
        }
        return this.getString().substring(start, this.getCursor());
    }

    @Override
    public @NonNull String parseString() throws ArgumentParseException {
        try {
            if (this.canRead() && this.peek() == '\"') {
                return this.readQuotedString();
            }
            return this.readUnquotedString();
        }
        catch (CommandSyntaxException e) {
            throw new ArgumentParseException((Component)Component.text((String)"Could not parse string"), (Throwable)e, this.getString(), this.getCursor());
        }
    }

    @Override
    public String peekString() throws ArgumentParseException {
        int currentCursor = this.getCursor();
        String peek = this.parseString();
        this.setCursor(currentCursor);
        return peek;
    }

    @Override
    public boolean parseBoolean() throws ArgumentParseException {
        try {
            return this.readBoolean();
        }
        catch (CommandSyntaxException e) {
            throw new ArgumentParseException((Component)Component.text((String)"Could not parse a boolean"), (Throwable)e, this.getString(), this.getCursor());
        }
    }

    @Override
    public String parseJson() throws ArgumentParseException {
        int startCursor = this.getCursor();
        try {
            this.readStruct();
        }
        catch (ArgumentParseException e) {
            this.setCursor(startCursor);
            throw e;
        }
        int endCursor = this.getCursor();
        return this.getInput().substring(startCursor, endCursor);
    }

    @Override
    public JsonObject parseJsonObject() throws ArgumentParseException {
        return new Gson().fromJson(this.parseJson(), JsonObject.class);
    }

    @Override
    public @NonNull SpongeImmutableArgumentReader getImmutable() {
        return new SpongeImmutableArgumentReader(this.getString(), this.getCursor());
    }

    @Override
    public void setState(@NonNull ArgumentReader state) throws IllegalArgumentException {
        if (!state.getInput().equals(this.getString())) {
            throw new IllegalArgumentException("The provided ArgumentReader does not match this ArgumentReader");
        }
        this.setCursor(state.getCursor());
    }

    @Override
    public @NonNull ArgumentParseException createException(@NonNull Component errorMessage) {
        return new ArgumentParseException(errorMessage, this.getInput(), this.getCursor());
    }

    public @NonNull ArgumentParseException createException(@NonNull Component errorMessage, @NonNull Throwable inner) {
        return new ArgumentParseException(errorMessage, inner, this.getInput(), this.getCursor());
    }

    protected String readKey() throws ArgumentParseException {
        this.skipWhitespace();
        if (!this.canRead()) {
            throw this.createException((Component)Component.text((String)"Unable to read JSON key"));
        }
        return this.getString();
    }

    public void readValue() throws ArgumentParseException {
        this.skipWhitespace();
        if (!this.canRead()) {
            throw this.createException((Component)Component.text((String)"Unable to read JSON value"));
        }
        char c0 = this.peek();
        if (c0 == '{') {
            this.readStruct();
        } else if (c0 == '[') {
            this.readList();
        } else {
            this.readValue();
        }
    }

    protected void readList() throws ArgumentParseException {
        if (this.canRead(3) && !StringReader.isQuotedStringStart((char)this.peek(1)) && this.peek(2) == ';') {
            this.readArrayTag();
        } else {
            this.readListTag();
        }
    }

    public void readStruct() throws ArgumentParseException {
        this.expectAfterWhitespace('{');
        this.skipWhitespace();
        while (this.canRead() && this.peek() != '}') {
            String s2 = this.readKey();
            if (s2.isEmpty()) {
                throw this.createException((Component)Component.text((String)"Unable to read JSON key"));
            }
            try {
                this.expect(':');
            }
            catch (CommandSyntaxException e) {
                throw this.createException((Component)Component.text((String)e.getMessage()));
            }
            if (!this.hasElementSeparator()) break;
            if (this.canRead()) continue;
            throw this.createException((Component)Component.text((String)"Unable to read JSON key"));
        }
        this.expectAfterWhitespace('}');
    }

    private void readListTag() throws ArgumentParseException {
        this.expectAfterWhitespace('[');
        this.skipWhitespace();
        if (!this.canRead()) {
            throw this.createException((Component)Component.text((String)"Unable to read JSON list"));
        }
        while (this.peek() != ']') {
            this.readValue();
            if (!this.hasElementSeparator()) break;
            if (this.canRead()) continue;
            throw this.createException((Component)Component.text((String)"Unable to read JSON value"));
        }
        this.expectAfterWhitespace(']');
    }

    private void readArrayTag() throws ArgumentParseException {
        this.expectAfterWhitespace('[');
        this.read();
        this.read();
        this.skipWhitespace();
        if (!this.canRead()) {
            throw this.createException((Component)Component.text((String)"Unable to read JSON array"));
        }
        this.readArray();
    }

    private void readArray() throws ArgumentParseException {
        while (this.peek() != ']') {
            this.readValue();
            if (!this.hasElementSeparator()) break;
            if (this.canRead()) continue;
            throw this.createException((Component)Component.text((String)"Unable to read JSON value"));
        }
        this.expectAfterWhitespace(']');
    }

    private boolean hasElementSeparator() {
        this.skipWhitespace();
        if (this.canRead() && this.peek() == ',') {
            this.skip();
            this.skipWhitespace();
            return true;
        }
        return false;
    }

    private void expectAfterWhitespace(char expected) throws ArgumentParseException {
        this.skipWhitespace();
        try {
            this.expect(expected);
        }
        catch (CommandSyntaxException e) {
            throw this.createException((Component)Component.text((String)e.getMessage()));
        }
    }

    private ResourceKey readResourceLocation(@Nullable String defaultNamespace) throws ArgumentParseException {
        int i = this.getCursor();
        while (this.canRead() && ResourceLocation.isValidPathCharacter((char)this.peek())) {
            this.skip();
        }
        String s2 = this.getString().substring(i, this.getCursor());
        if (s2.contains(":")) {
            return ResourceKey.resolve(s2);
        }
        if (defaultNamespace == null) {
            this.setCursor(i);
            throw this.createException((Component)Component.translatable((String)"argument.id.invalid"));
        }
        return ResourceKey.of(defaultNamespace, s2);
    }
}

