/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.manager;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.leangen.geantyref.TypeToken;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.logging.log4j.Level;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.exception.CommandException;
import org.spongepowered.api.command.manager.CommandFailedRegistrationException;
import org.spongepowered.api.command.manager.CommandManager;
import org.spongepowered.api.command.manager.CommandMapping;
import org.spongepowered.api.command.registrar.CommandRegistrar;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.command.ExecuteCommandEvent;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.util.ComponentMessageException;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.command.exception.SpongeCommandSyntaxException;
import org.spongepowered.common.command.manager.SpongeCommandMapping;
import org.spongepowered.common.command.registrar.BrigadierCommandRegistrar;
import org.spongepowered.common.command.registrar.SpongeParameterizedCommandRegistrar;
import org.spongepowered.common.command.registrar.tree.builder.RootCommandTreeNode;
import org.spongepowered.common.command.sponge.SpongeCommand;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.lifecycle.RegisterCommandEventImpl;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.service.game.pagination.SpongePaginationService;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.plugin.PluginContainer;

@Singleton
public final class SpongeCommandManager
implements CommandManager {
    private static final boolean ALWAYS_PRINT_STACKTRACES = System.getProperty("sponge.command.alwaysPrintStacktraces") != null;
    private final Game game;
    private final Provider<SpongeCommand> spongeCommand;
    private final Map<String, SpongeCommandMapping> commandMappings = new HashMap<String, SpongeCommandMapping>();
    private final Multimap<SpongeCommandMapping, String> inverseCommandMappings = HashMultimap.create();
    private final Multimap<PluginContainer, SpongeCommandMapping> pluginToCommandMap = HashMultimap.create();
    private final LinkedHashMap<SpongeCommandMapping, RootCommandTreeNode> mappingToSuggestionNodes = new LinkedHashMap();
    private boolean isResetting = false;
    private boolean hasStarted = false;

    @Inject
    public SpongeCommandManager(Game game, Provider<SpongeCommand> spongeCommand) {
        this.game = game;
        this.spongeCommand = spongeCommand;
    }

    @Override
    public Set<String> getKnownAliases() {
        return ImmutableSet.copyOf(this.commandMappings.keySet());
    }

    public @NonNull CommandMapping registerNamespacedAlias(@NonNull CommandRegistrar<?> registrar, @NonNull PluginContainer container, @NonNull LiteralCommandNode<CommandSource> rootArgument, String ... secondaryAliases) throws CommandFailedRegistrationException {
        String namespaced = rootArgument.getLiteral();
        String notnamespaced = namespaced.split(":")[1];
        ArrayList<String> otherAliases = new ArrayList<String>();
        otherAliases.add(notnamespaced);
        otherAliases.addAll(Arrays.asList(secondaryAliases));
        return this.registerAliasWithNamespacing(registrar, container, namespaced, otherAliases, null);
    }

    @Override
    public @NonNull CommandMapping registerAlias(@NonNull CommandRegistrar<?> registrar, @NonNull PluginContainer container,  @NonNull CommandTreeNode.Root parameterTree, @NonNull String primaryAlias, String ... secondaryAliases) throws CommandFailedRegistrationException {
        ArrayList<String> aliases = new ArrayList<String>();
        aliases.add(primaryAlias);
        Collections.addAll(aliases, secondaryAliases);
        String namespaced = container.getMetadata().getId() + ":" + primaryAlias.toLowerCase(Locale.ROOT);
        return this.registerAliasWithNamespacing(registrar, container, namespaced, aliases, parameterTree);
    }

    public @NonNull CommandMapping registerAliasWithNamespacing(@NonNull CommandRegistrar<?> registrar, @NonNull PluginContainer container, @NonNull String namespacedAlias, @NonNull Collection<String> otherAliases,  @Nullable CommandTreeNode.Root parameterTree) throws CommandFailedRegistrationException {
        if (namespacedAlias.contains(" ") || otherAliases.stream().anyMatch(x -> x.contains(" ") || x.contains(":"))) {
            throw new CommandFailedRegistrationException("Aliases may not contain spaces or colons.");
        }
        if (this.commandMappings.containsKey(namespacedAlias)) {
            throw new CommandFailedRegistrationException("The command alias " + namespacedAlias + " has already been registered for this plugin");
        }
        HashSet<String> aliases = new HashSet<String>();
        aliases.add(namespacedAlias);
        for (String secondaryAlias : otherAliases) {
            aliases.add(secondaryAlias.toLowerCase(Locale.ROOT));
        }
        aliases.removeIf(this.commandMappings::containsKey);
        SpongeConfigs.getCommon().get().getCommands().getAliases().entrySet().stream().filter(x -> !((String)x.getValue()).equalsIgnoreCase(container.getMetadata().getId())).filter(x -> aliases.contains(x.getKey())).forEach(x -> aliases.remove(x.getKey()));
        if (aliases.isEmpty()) {
            throw new CommandFailedRegistrationException("No aliases could be registered for the supplied command.");
        }
        SpongeCommandMapping mapping = new SpongeCommandMapping(namespacedAlias, aliases, container, registrar);
        this.pluginToCommandMap.put((Object)container, (Object)mapping);
        aliases.forEach(key -> {
            this.commandMappings.put((String)key, mapping);
            this.inverseCommandMappings.put((Object)mapping, key);
        });
        if (parameterTree instanceof RootCommandTreeNode) {
            this.mappingToSuggestionNodes.put(mapping, (RootCommandTreeNode)parameterTree);
        }
        return mapping;
    }

    @Override
    public @NonNull Collection<PluginContainer> getPlugins() {
        return ImmutableSet.copyOf((Collection)this.pluginToCommandMap.keySet());
    }

    @Override
    public @NonNull Optional<CommandMapping> getCommandMapping(String alias) {
        return Optional.ofNullable(this.commandMappings.get(alias.toLowerCase()));
    }

    @Override
    public boolean isResetting() {
        return this.isResetting;
    }

    @Override
    public void updateCommandTreeForPlayer(@NonNull ServerPlayer player) {
        Objects.requireNonNull(player, "player");
        SpongeCommon.getServer().getCommandManager().send((ServerPlayerEntity)player);
    }

    @Override
    public @NonNull CommandResult process(@NonNull String arguments) throws CommandException {
        try {
            return this.process(CommandCause.create(), arguments);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            throw new CommandException((Component)Component.text((String)commandSyntaxException.getMessage()), (Throwable)commandSyntaxException);
        }
    }

    public CommandResult process(CommandCause cause, String arguments) throws CommandException, CommandSyntaxException {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            CommandResult result;
            String args;
            String command;
            String originalArgs;
            frame.addContext(EventContextKeys.COMMAND.get(), arguments);
            String[] splitArg = arguments.split(" ", 2);
            String originalCommand = splitArg[0];
            String string = originalArgs = splitArg.length == 2 ? splitArg[1] : "";
            if (ShouldFire.EXECUTE_COMMAND_EVENT_PRE) {
                ExecuteCommandEvent.Pre preEvent = SpongeEventFactory.createExecuteCommandEventPre(cause.getCause(), originalArgs, originalArgs, originalCommand, originalCommand, cause, Optional.empty(), false);
                if (this.game.getEventManager().post(preEvent)) {
                    CommandResult commandResult = preEvent.getResult().orElse(CommandResult.empty());
                    return commandResult;
                }
                command = preEvent.getCommand();
                args = preEvent.getArguments();
            } else {
                command = originalCommand;
                args = originalArgs;
            }
            SpongeCommandMapping mapping = this.commandMappings.get(command.toLowerCase());
            if (mapping == null) {
                throw new CommandException((Component)Component.text((String)"Unknown command. Type /help for a list of commands."));
            }
            try {
                result = mapping.getRegistrar().process(cause, mapping, command, args);
            }
            catch (CommandException exception) {
                CommandResult errorResult = CommandResult.builder().setResult(0).error(exception.componentMessage()).build();
                this.postExecuteCommandPostEvent(cause, originalArgs, args, originalCommand, command, errorResult);
                if (ALWAYS_PRINT_STACKTRACES) {
                    this.prettyPrintThrowableError(exception, command, args, cause);
                }
                throw exception;
            }
            catch (net.minecraft.command.CommandException ex) {
                CommandResult errorResult = CommandResult.builder().setResult(0).error(SpongeAdventure.asAdventure(ex.getComponent())).build();
                this.postExecuteCommandPostEvent(cause, originalArgs, args, originalCommand, command, errorResult);
                if (ALWAYS_PRINT_STACKTRACES) {
                    this.prettyPrintThrowableError(ex, command, args, cause);
                }
                throw ex;
            }
            catch (Throwable thr) {
                Component text;
                this.prettyPrintThrowableError(thr, command, args, cause);
                Object excBuilder = thr instanceof ComponentMessageException ? ((text = ((ComponentMessageException)thr).componentMessage()) == null ? Component.text((String)"null") : text) : Component.text((String)String.valueOf(thr.getMessage()));
                if (cause.hasPermission("sponge.debug.hover-stacktrace")) {
                    StringWriter writer = new StringWriter();
                    thr.printStackTrace(new PrintWriter(writer));
                    excBuilder = excBuilder.hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)writer.toString().replace("\t", "    ").replace("\r\n", "\n").replace("\r", "\n"))));
                }
                BuildableComponent error = ((TextComponent.Builder)Component.text().content("Unexpected error occurred while executing command: ").append((Component)excBuilder)).build();
                this.postExecuteCommandPostEvent(cause, originalArgs, args, originalCommand, command, CommandResult.error((Component)error));
                throw new CommandException((Component)error, thr);
            }
            this.postExecuteCommandPostEvent(cause, originalArgs, args, originalCommand, command, result);
            result.getErrorMessage().ifPresent(x -> cause.sendMessage(Identity.nil(), (Component)x));
            CommandResult commandResult = result;
            return commandResult;
        }
    }

    @Override
    public <T extends Subject & Audience> @NonNull CommandResult process(@NonNull T subjectReceiver, @NonNull String arguments) throws CommandException {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SUBJECT.get(), subjectReceiver);
            frame.addContext(EventContextKeys.AUDIENCE.get(), subjectReceiver);
            CommandResult commandResult = this.process(arguments);
            return commandResult;
        }
    }

    @Override
    public @NonNull CommandResult process(@NonNull Subject subject, @NonNull Audience receiver, @NonNull String arguments) throws CommandException {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SUBJECT.get(), subject);
            frame.addContext(EventContextKeys.AUDIENCE.get(), receiver);
            CommandResult commandResult = this.process(arguments);
            return commandResult;
        }
    }

    private void postExecuteCommandPostEvent(CommandCause cause, String originalArgs, String args, String originalCommand, String command, CommandResult result) {
        if (ShouldFire.EXECUTE_COMMAND_EVENT_POST) {
            this.game.getEventManager().post(SpongeEventFactory.createExecuteCommandEventPost(cause.getCause(), originalArgs, args, originalCommand, command, cause, result));
        }
    }

    private void prettyPrintThrowableError(Throwable thr, String commandNoArgs, String args, CommandCause cause) {
        String commandString = args != null && !args.isEmpty() ? commandNoArgs + " " + args : commandNoArgs;
        SpongeCommandMapping mapping = this.commandMappings.get(commandNoArgs.toLowerCase());
        PrettyPrinter prettyPrinter = new PrettyPrinter(100).add("Unexpected error occurred while executing command '%s'", commandString).centre().hr().addWrapped("While trying to run '%s', an error occurred that the command processor was not expecting. This usually indicates an error in the plugin that owns this command. Report this error to the plugin developer first - this is usually not a Sponge error.", commandString).hr().add().add("Command: %s", commandString).add("Owning Plugin: %s", mapping.getPlugin().getMetadata().getId()).add("Owning Registrar: %s", mapping.getRegistrar().getClass().getName()).add().add("Exception Details: ");
        if (thr instanceof SpongeCommandSyntaxException) {
            prettyPrinter.add(thr.getCause());
        } else {
            prettyPrinter.add(thr);
        }
        prettyPrinter.add().add("CommandCause details: ").addWrapped(cause.getCause().toString(), new Object[0]).log(SpongeCommon.getLogger(), Level.ERROR);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public @NonNull List<String> suggest(@NonNull String arguments) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.COMMAND.get(), arguments);
            String[] splitArg = arguments.split(" ", 2);
            String command = splitArg[0].toLowerCase();
            if (splitArg.length == 2) {
                SpongeCommandMapping mapping = this.commandMappings.get(command);
                if (mapping == null) {
                    List<String> list = Collections.emptyList();
                    return list;
                }
                List<String> list = mapping.getRegistrar().suggestions(CommandCause.create(), mapping, command, splitArg[1]);
                return list;
            }
            List<String> list = this.commandMappings.keySet().stream().filter(x -> x.startsWith(command)).collect(Collectors.toList());
            return list;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    @Override
    public <T extends Subject & Audience> @NonNull List<String> suggest(@NonNull T subjectReceiver, @NonNull String arguments) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SUBJECT.get(), subjectReceiver);
            frame.addContext(EventContextKeys.AUDIENCE.get(), subjectReceiver);
            List<String> list = this.suggest(arguments);
            return list;
        }
    }

    @Override
    public @NonNull List<String> suggest(@NonNull Subject subject, @NonNull Audience receiver, @NonNull String arguments) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SUBJECT.get(), subject);
            frame.addContext(EventContextKeys.AUDIENCE.get(), receiver);
            List<String> list = this.suggest(arguments);
            return list;
        }
    }

    public void init() {
        Cause cause = PhaseTracker.getCauseStackManager().getCurrentCause();
        try {
            SpongeParameterizedCommandRegistrar.INSTANCE.register(((Launch)Launch.getInstance()).getCommonPlugin(), ((SpongeCommand)this.spongeCommand.get()).createSpongeCommand(), "sponge", new String[0]);
        }
        catch (CommandFailedRegistrationException ex) {
            throw new RuntimeException("Failed to create root Sponge command!", ex);
        }
        try {
            PaginationService paginationService = Sponge.getServiceProvider().paginationService();
            if (paginationService instanceof SpongePaginationService) {
                SpongeParameterizedCommandRegistrar.INSTANCE.register(((Launch)Launch.getInstance()).getCommonPlugin(), ((SpongePaginationService)paginationService).createPaginationCommand(), "pagination", "page");
            }
        }
        catch (CommandFailedRegistrationException ex) {
            throw new RuntimeException("Failed to create pagination command!", ex);
        }
        HashSet usedTokens = new HashSet();
        for (CommandRegistrar registrar : this.game.getRegistry().getCatalogRegistry().getAllOf(CommandRegistrar.class)) {
            TypeToken handledType = registrar.handledType();
            if (handledType == null) {
                SpongeCommon.getLogger().error("Registrar '{}' did not provide a handledType, skipping...", (Object)registrar.getClass());
                continue;
            }
            if (usedTokens.add(handledType)) {
                this.game.getEventManager().post(this.createEvent(cause, this.game, registrar));
                continue;
            }
            SpongeCommon.getLogger().warn("Command type '{}' has already been collected, skipping request from {}", (Object)handledType.toString(), (Object)registrar.getClass());
        }
        SpongeParameterizedCommandRegistrar.INSTANCE.register(((Launch)Launch.getInstance()).getCommonPlugin(), SpongeAdventure.CALLBACK_COMMAND.createCommand(), "callback", new String[0]);
        BrigadierCommandRegistrar.INSTANCE.completeVanillaRegistration();
        this.hasStarted = true;
    }

    public Collection<CommandNode<ISuggestionProvider>> getNonBrigadierSuggestions(CommandCause cause) {
        ArrayList<CommandNode<ISuggestionProvider>> suggestions = new ArrayList<CommandNode<ISuggestionProvider>>();
        for (Map.Entry<SpongeCommandMapping, RootCommandTreeNode> entry : this.mappingToSuggestionNodes.entrySet()) {
            SpongeCommandMapping mapping = entry.getKey();
            CommandNode node = entry.getValue().createArgumentTree(cause, (LiteralArgumentBuilder<ISuggestionProvider>)LiteralArgumentBuilder.literal((String)mapping.getPrimaryAlias()));
            if (node == null) continue;
            Command executableCommand = node.getCommand();
            CommandNode toRedirectTo = node.getRedirect() == null ? node : node.getRedirect();
            suggestions.add((CommandNode<ISuggestionProvider>)node);
            for (String alias : mapping.getAllAliases()) {
                if (alias.equals(mapping.getPrimaryAlias())) continue;
                suggestions.add((CommandNode<ISuggestionProvider>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)alias).executes(executableCommand)).redirect(toRedirectTo)).build());
            }
        }
        return suggestions;
    }

    public void reset() {
        if (this.hasStarted) {
            this.isResetting = true;
            for (CommandRegistrar registrar : this.game.getRegistry().getCatalogRegistry().getAllOf(CommandRegistrar.class)) {
                registrar.reset();
            }
            this.commandMappings.clear();
            this.inverseCommandMappings.clear();
            this.pluginToCommandMap.clear();
            this.isResetting = false;
        }
    }

    public Collection<String> getAliasesThatStartWithForCause(CommandCause cause, String startingText) {
        String toCompare = startingText.toLowerCase(Locale.ROOT);
        ArrayList<String> aliases = new ArrayList<String>();
        Object2BooleanOpenHashMap testedMappings = new Object2BooleanOpenHashMap();
        for (Map.Entry<String, SpongeCommandMapping> mappingEntry : this.commandMappings.entrySet()) {
            if (!mappingEntry.getKey().startsWith(toCompare) || !testedMappings.computeBooleanIfAbsent((Object)mappingEntry.getValue(), mapping -> mapping.getRegistrar().canExecute(cause, (CommandMapping)mapping))) continue;
            aliases.add(toCompare);
        }
        return aliases;
    }

    public Collection<String> getAliasesForCause(CommandCause cause) {
        ArrayList<String> aliases = new ArrayList<String>();
        for (SpongeCommandMapping mapping : this.inverseCommandMappings.keySet()) {
            if (!mapping.getRegistrar().canExecute(cause, mapping)) continue;
            aliases.addAll(this.inverseCommandMappings.get((Object)mapping));
        }
        return aliases;
    }

    private <C, R extends CommandRegistrar<C>> RegisterCommandEventImpl<C, R> createEvent(Cause cause, Game game, R registrar) {
        return new RegisterCommandEventImpl(cause, game, registrar);
    }

    private Component asTextComponent(Message message) {
        if (message instanceof ITextComponent) {
            return TextComponent.ofChildren((ComponentLike[])new ComponentLike[]{SpongeAdventure.asAdventure((ITextComponent)message)});
        }
        return Component.text((String)message.getString());
    }
}

