/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.ValueCompleter;
import org.spongepowered.api.command.parameter.managed.ValueParser;
import org.spongepowered.api.command.parameter.managed.ValueUsage;
import org.spongepowered.common.command.parameter.SpongeParameterKey;
import org.spongepowered.common.command.parameter.SpongeParameterValue;

public final class SpongeParameterValueBuilder<T>
implements Parameter.Value.Builder<T> {
    private static final ValueCompleter EMPTY_COMPLETER = (context, currentInput) -> ImmutableList.of();
    private final Type typeToken;
    private final List<ValueParser<? extends T>> parsers = new ArrayList<ValueParser<? extends T>>();
    private  @Nullable Parameter.Key<T> key;
    private @Nullable ValueCompleter completer;
    private @Nullable ValueUsage usage;
    private @Nullable Predicate<CommandCause> executionRequirements;
    private @Nullable Function<CommandCause, T> defaultValueFunction;
    private boolean consumesAll;
    private boolean isOptional;
    private boolean terminal;

    public SpongeParameterValueBuilder(@NonNull Type token) {
        this.typeToken = token;
    }

    @Override
    public  @NonNull Parameter.Value.Builder<T> setKey(@NonNull String key) {
        return this.setKey(new SpongeParameterKey(key, this.typeToken));
    }

    @Override
    public  @NonNull Parameter.Value.Builder<T> setKey( @NonNull Parameter.Key<T> key) {
        Objects.requireNonNull(key, "The key cannot be null");
        this.key = key;
        return this;
    }

    @Override
    public  @NonNull Parameter.Value.Builder<T> parser(@NonNull ValueParser<? extends T> parser) {
        this.parsers.add(Objects.requireNonNull(parser, "The ValueParser may not be null"));
        return this;
    }

    @Override
    public  @NonNull Parameter.Value.Builder<T> setSuggestions(@Nullable ValueCompleter completer) {
        this.completer = completer;
        return this;
    }

    @Override
    public  @NonNull Parameter.Value.Builder<T> setUsage(@Nullable ValueUsage usage) {
        this.usage = usage;
        return this;
    }

    @Override
    public  @NonNull Parameter.Value.Builder<T> setRequiredPermission(@Nullable String permission) {
        if (permission == null) {
            return this.setUsage(null);
        }
        return this.setRequirements(commandCause -> commandCause.getSubject().hasPermission(permission));
    }

    @Override
    public  @NonNull Parameter.Value.Builder<T> setRequirements(@Nullable Predicate<CommandCause> executionRequirements) {
        this.executionRequirements = executionRequirements;
        return this;
    }

    @Override
    public  @NonNull Parameter.Value.Builder<T> consumeAllRemaining() {
        this.consumesAll = true;
        return this.terminal();
    }

    @Override
    public  @NonNull Parameter.Value.Builder<T> optional() {
        this.isOptional = true;
        return this;
    }

    @Override
    public  @NonNull Parameter.Value.Builder<T> orDefault(@NonNull Supplier<T> defaultValueSupplier) {
        return this.orDefault((CommandCause cause) -> defaultValueSupplier.get());
    }

    @Override
    public  @NonNull Parameter.Value.Builder<T> orDefault(@Nullable Function<CommandCause, T> defaultValueFunction) {
        this.defaultValueFunction = defaultValueFunction;
        return this;
    }

    @Override
    public  @NonNull Parameter.Value.Builder<T> terminal() {
        this.terminal = true;
        return this;
    }

    @Override
    public @NonNull SpongeParameterValue<T> build() throws IllegalStateException {
        ValueCompleter completer;
        Preconditions.checkState((this.key != null ? 1 : 0) != 0, (Object)"The command key may not be null");
        Preconditions.checkState((!this.parsers.isEmpty() || this.defaultValueFunction != null ? 1 : 0) != 0, (Object)"There must be parsers or a default");
        ImmutableList.Builder parsersBuilder = ImmutableList.builder();
        parsersBuilder.addAll(this.parsers);
        if (this.completer != null) {
            completer = this.completer;
        } else {
            ImmutableList.Builder completersBuilder = ImmutableList.builder();
            for (ValueParser<? extends T> valueParser : this.parsers) {
                if (!(valueParser instanceof ValueCompleter)) continue;
                completersBuilder.add((Object)((ValueCompleter)((Object)valueParser)));
            }
            ImmutableList completers = completersBuilder.build();
            completer = completers.isEmpty() ? EMPTY_COMPLETER : (completers.size() == 1 ? (ValueCompleter)completers.get(0) : (context, currentInput) -> {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (ValueCompleter valueCompleter : completers) {
                    builder.addAll(valueCompleter.complete(context, currentInput));
                }
                return builder.build();
            });
        }
        return new SpongeParameterValue<T>(parsersBuilder.build(), this.defaultValueFunction, completer, this.usage, this.executionRequirements == null ? commandCause -> true : this.executionRequirements, this.key, this.isOptional, this.consumesAll, this.terminal);
    }

    @Override
    public  @NonNull Parameter.Value.Builder<T> reset() {
        this.key = null;
        this.parsers.clear();
        this.completer = null;
        this.usage = null;
        this.defaultValueFunction = null;
        this.isOptional = false;
        this.consumesAll = false;
        return this;
    }
}

