/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.standard;

import com.mojang.brigadier.arguments.ArgumentType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.command.brigadier.argument.AbstractArgumentParser;
import org.spongepowered.common.util.Constants;

public final class SpongeCatalogedElementValueParameter<T extends CatalogType>
extends AbstractArgumentParser<T> {
    private final List<String> prefixes;
    private final Class<T> catalogType;

    public SpongeCatalogedElementValueParameter(List<String> prefixes, Class<T> catalogType) {
        this.prefixes = prefixes;
        this.catalogType = catalogType;
    }

    @Override
    public @NonNull Optional<? extends T> getValue( @NonNull Parameter.Key<? super T> parameterKey,  @NonNull ArgumentReader.Mutable reader, @NonNull CommandContext.Builder context) throws ArgumentParseException {
        try {
            ResourceKey resourceKey = reader.parseResourceKey();
            Optional<T> result = SpongeCommon.getRegistry().getCatalogRegistry().get(this.catalogType, resourceKey);
            if (!result.isPresent()) {
                throw reader.createException((Component)Component.text((String)("No " + this.catalogType.getSimpleName() + " with ID " + resourceKey.asString() + "exists")));
            }
            return result;
        }
        catch (ArgumentParseException ex) {
            if (this.prefixes.isEmpty()) {
                throw ex;
            }
            String check = reader.parseUnquotedString();
            for (String prefix : this.prefixes) {
                Optional<T> result = SpongeCommon.getRegistry().getCatalogRegistry().get(this.catalogType, ResourceKey.of(prefix, check));
                if (!result.isPresent()) continue;
                return result;
            }
            String ids = this.prefixes.stream().map(x -> x + ":" + check).collect(Collectors.joining(", "));
            throw reader.createException((Component)Component.text((String)("No " + this.catalogType.getSimpleName() + " with any of the following IDs exist: " + ids)));
        }
    }

    @Override
    public @NonNull List<String> complete(@NonNull CommandContext context, @NonNull String currentInput) {
        String lowerCase = currentInput.toLowerCase();
        return SpongeCommon.getRegistry().getCatalogRegistry().streamAllOf(this.catalogType).map(CatalogType::getKey).map(x -> {
            if (x.asString().startsWith(lowerCase)) {
                return x.asString();
            }
            if (this.prefixes.contains(x.getNamespace()) && x.getValue().startsWith(lowerCase)) {
                return x.getValue();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public List<ArgumentType<?>> getClientCompletionArgumentType() {
        return Collections.singletonList(Constants.Command.RESOURCE_LOCATION_TYPE);
    }
}

