/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.standard;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.GameProfileArgument;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.common.command.brigadier.argument.CatalogedArgumentParser;
import org.spongepowered.common.profile.SpongeGameProfile;

public final class SpongeGameProfileValueParameter
extends CatalogedArgumentParser<GameProfile> {
    private final ResourceKey resourceKey = ResourceKey.sponge("game_profile");
    private final GameProfileArgument argument = GameProfileArgument.gameProfile();

    @Override
    public ResourceKey getKey() {
        return this.resourceKey;
    }

    @Override
    public CompletableFuture<Suggestions> listSuggestions(CommandContext<?> context, SuggestionsBuilder builder) {
        return this.argument.listSuggestions(context, builder);
    }

    @Override
    public @NonNull List<String> complete(@NonNull org.spongepowered.api.command.parameter.CommandContext context, @NonNull String currentInput) {
        SuggestionsBuilder builder = new SuggestionsBuilder(currentInput, 0);
        this.listSuggestions((CommandContext)context, builder);
        return builder.build().getList().stream().map(Suggestion::getText).collect(Collectors.toList());
    }

    @Override
    public Optional<? extends GameProfile> getValue( @NonNull Parameter.Key<? super GameProfile> parameterKey,  @NonNull ArgumentReader.Mutable reader,  @NonNull CommandContext.Builder context) throws ArgumentParseException {
        try {
            Collection profileCollection = this.argument.parse((StringReader)reader).getNames((CommandSource)context.getCause());
            if (profileCollection.size() == 1) {
                return Optional.of(SpongeGameProfile.of((com.mojang.authlib.GameProfile)profileCollection.iterator().next()));
            }
            if (profileCollection.isEmpty()) {
                throw reader.createException((Component)Component.text((String)"No game profiles were selected."));
            }
            throw reader.createException((Component)Component.text((String)"Many game profiles were selected when only one was requested."));
        }
        catch (CommandSyntaxException e) {
            throw new ArgumentParseException((Component)Component.text((String)e.getMessage()), (Throwable)e, reader.getInput(), reader.getCursor());
        }
    }
}

