/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.standard;

import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.common.command.brigadier.argument.CatalogedArgumentParser;

public final class SpongeIPAddressValueParameter
extends CatalogedArgumentParser<InetAddress> {
    private static final ResourceKey RESOURCE_KEY = ResourceKey.sponge("ip");

    @Override
    public @NonNull ResourceKey getKey() {
        return RESOURCE_KEY;
    }

    @Override
    public @NonNull List<String> complete(@NonNull CommandContext context, String currentInput) {
        return ImmutableList.of();
    }

    @Override
    public @NonNull Optional<? extends InetAddress> getValue( @NonNull Parameter.Key<? super InetAddress> parameterKey,  @NonNull ArgumentReader.Mutable reader, @NonNull CommandContext.Builder context) throws ArgumentParseException {
        String stringToParse = reader.parseString();
        try {
            return Optional.of(InetAddress.getByName(stringToParse));
        }
        catch (UnknownHostException e) {
            throw reader.createException((Component)Component.text((String)e.getMessage()));
        }
    }
}

