/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.Type;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.registry.GameRegistry;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

@Singleton
public final class CatalogTypeTypeSerializer
implements TypeSerializer<CatalogType> {
    public static final Class<CatalogType> TYPE = CatalogType.class;
    private final GameRegistry registry;

    @Inject
    CatalogTypeTypeSerializer(GameRegistry registry) {
        this.registry = registry;
    }

    @Override
    public CatalogType deserialize(Type type, ConfigurationNode value) throws SerializationException {
        Optional<CatalogType> ret = this.registry.getCatalogRegistry().get(GenericTypeReflector.erase(type).asSubclass(CatalogType.class), ResourceKey.resolve(value.getString()));
        if (!ret.isPresent()) {
            throw new SerializationException("Input '" + value.raw() + "' was not a valid value for type " + type);
        }
        return ret.get();
    }

    @Override
    public void serialize(Type type, @Nullable CatalogType obj, ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            value.set(null);
        } else {
            value.set(obj.getKey().getFormatted());
        }
    }
}

