/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.inheritable;

import org.spongepowered.common.applaunch.config.core.Config;
import org.spongepowered.common.config.inheritable.BlockEntityActivationCategory;
import org.spongepowered.common.config.inheritable.EntityActivationRangeCategory;
import org.spongepowered.common.config.inheritable.EntityCategory;
import org.spongepowered.common.config.inheritable.EntityCollisionCategory;
import org.spongepowered.common.config.inheritable.LoggingCategory;
import org.spongepowered.common.config.inheritable.MovementChecksCategory;
import org.spongepowered.common.config.inheritable.PlayerBlockTracker;
import org.spongepowered.common.config.inheritable.SpawnerCategory;
import org.spongepowered.common.config.inheritable.WorldCategory;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.objectmapping.meta.Setting;
import org.spongepowered.configurate.transformation.ConfigurationTransformation;
import org.spongepowered.configurate.transformation.TransformAction;

public abstract class BaseConfig
implements Config {
    @Setting
    protected WorldCategory world = new WorldCategory();
    @Setting
    private PlayerBlockTracker playerBlockTracker = new PlayerBlockTracker();
    @Setting
    private EntityCategory entity = new EntityCategory();
    @Setting(value="entity-activation-range")
    private EntityActivationRangeCategory entityActivationRange = new EntityActivationRangeCategory();
    @Setting(value="entity-collisions")
    private EntityCollisionCategory entityCollisionCategory = new EntityCollisionCategory();
    @Setting
    private LoggingCategory logging = new LoggingCategory();
    @Setting(value="spawner")
    @Comment(value="Used to control spawn limits around players. \nNote: The radius uses the lower value of mob spawn range and server's view distance.")
    private SpawnerCategory spawner = new SpawnerCategory();
    @Setting(value="tileentity-activation")
    private BlockEntityActivationCategory blockEntityActivationCategory = new BlockEntityActivationCategory();
    @Setting(value="movement-checks")
    private MovementChecksCategory movementChecks = new MovementChecksCategory();

    public PlayerBlockTracker getBlockTracking() {
        return this.playerBlockTracker;
    }

    public EntityCategory getEntity() {
        return this.entity;
    }

    public EntityActivationRangeCategory getEntityActivationRange() {
        return this.entityActivationRange;
    }

    public EntityCollisionCategory getEntityCollisionCategory() {
        return this.entityCollisionCategory;
    }

    public LoggingCategory getLogging() {
        return this.logging;
    }

    public SpawnerCategory getSpawner() {
        return this.spawner;
    }

    public WorldCategory getWorld() {
        return this.world;
    }

    public BlockEntityActivationCategory getTileEntityActivationRange() {
        return this.blockEntityActivationCategory;
    }

    public MovementChecksCategory getMovementChecks() {
        return this.movementChecks;
    }

    @Override
    public ConfigurationTransformation getTransformation() {
        return ConfigurationTransformation.versionedBuilder().addVersion(2, this.buildOneToTwo()).addVersion(1, this.buildInitialToOne()).build();
    }

    protected ConfigurationTransformation buildOneToTwo() {
        return ConfigurationTransformation.builder().addAction(NodePath.path("world", "portal-agents"), TransformAction.remove()).build();
    }

    protected ConfigurationTransformation buildInitialToOne() {
        return ConfigurationTransformation.builder().addAction(NodePath.path("sponge"), (path, value) -> new Object[0]).build();
    }
}

