/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.metrics;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.common.applaunch.config.core.Config;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.transformation.ConfigurationTransformation;
import org.spongepowered.plugin.PluginContainer;

@ConfigSerializable
public class MetricsConfiguration
implements Config {
    public static String FILE_NAME = "metrics.conf";
    @Comment(value="The global collection state that should be respected by all plugins that have no specified collection state. If undefined then it is treated as disabled.")
    private Tristate globalState = Tristate.UNDEFINED;
    @Comment(value="Plugin-specific collection states that override the global collection state.")
    private final Map<String, Tristate> pluginStates = new HashMap<String, Tristate>();

    public Tristate getGlobalCollectionState() {
        return this.globalState;
    }

    public Tristate getCollectionState(PluginContainer container) {
        Tristate pluginState = this.pluginStates.get(container.getMetadata().getId());
        return pluginState == null ? Tristate.UNDEFINED : pluginState;
    }

    public Map<String, Tristate> getCollectionStates() {
        return Collections.unmodifiableMap(this.pluginStates);
    }

    @Override
    public ConfigurationTransformation getTransformation() {
        return ConfigurationTransformation.versionedBuilder().makeVersion(1, b -> b.addAction(NodePath.path("metrics"), (path, value) -> new Object[0])).build();
    }
}

