/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import com.google.common.collect.ImmutableList;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataContentUpdater;
import org.spongepowered.api.data.persistence.DataView;

public class DataUpdaterDelegate
implements DataContentUpdater {
    private final ImmutableList<DataContentUpdater> updaters;
    private final int from;
    private final int to;

    public DataUpdaterDelegate(ImmutableList<DataContentUpdater> updaters, int from, int to) {
        this.updaters = updaters;
        this.from = from;
        this.to = to;
    }

    @Override
    public int getInputVersion() {
        return this.from;
    }

    @Override
    public int getOutputVersion() {
        return this.to;
    }

    @Override
    public DataView update(DataView content) {
        DataContainer copied;
        DataView updated = copied = content.copy();
        for (DataContentUpdater updater : this.updaters) {
            try {
                updated = updater.update(updated);
            }
            catch (Exception e) {
                RuntimeException exception = new RuntimeException("There was error attempting to update some data for the content updater:" + updater.getClass().getName() + "\nThe original data is being returned, possibly causing issues later on, \nbut the original data should not be lost. Please notify the developer of this exception with the stacktrace.", e);
                exception.printStackTrace();
                return copied;
            }
        }
        return updated;
    }
}

