/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.builder.authlib;

import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.common.util.Constants;

public class SpongeGameProfileBuilder
extends AbstractDataBuilder<GameProfile> {
    public SpongeGameProfileBuilder() {
        super(GameProfile.class, 0);
    }

    @Override
    protected Optional<GameProfile> buildContent(DataView container) throws InvalidDataException {
        if (!container.contains(Constants.Entity.Player.UUID)) {
            return Optional.empty();
        }
        UUID uuid = this.getUUIDByString(container.getString(Constants.Entity.Player.UUID).get());
        if (!container.contains(Constants.Entity.Player.NAME)) {
            return Optional.of(GameProfile.of(uuid));
        }
        return Optional.of(GameProfile.of(uuid, container.getString(Constants.Entity.Player.NAME).get()));
    }

    private UUID getUUIDByString(String uuidString) throws InvalidDataException {
        try {
            return UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidDataException("Invalid UUID string: " + uuidString);
        }
    }
}

