/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.datasync.entity;

import java.util.List;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.minecraft.entity.Entity;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.accessor.entity.EntityAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.data.datasync.DataParameterConverter;

public class EntityCustomNameConverter
extends DataParameterConverter<String> {
    public EntityCustomNameConverter() {
        super(EntityAccessor.accessor$getCustomName());
    }

    @Override
    public Optional<DataTransactionResult> createTransaction(Entity entity, String currentValue, String value) {
        Component currentText = SpongeAdventure.legacySection(currentValue);
        Component newValue = SpongeAdventure.legacySection(value);
        return Optional.of(DataTransactionResult.builder().replace(Value.immutableOf(Keys.DISPLAY_NAME, currentText)).success(Value.immutableOf(Keys.DISPLAY_NAME, newValue)).result(DataTransactionResult.Type.SUCCESS).build());
    }

    @Override
    public String getValueFromEvent(String originalValue, List<Value.Immutable<?>> immutableValues) {
        for (Value.Immutable<?> value : immutableValues) {
            if (value.getKey() != Keys.DISPLAY_NAME.get()) continue;
            try {
                return SpongeAdventure.legacySection((Component)value.get());
            }
            catch (Exception e) {
                return originalValue;
            }
        }
        return originalValue;
    }
}

