/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.persistence;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.InvalidDataFormatException;
import org.spongepowered.api.data.persistence.StringDataFormat;
import org.spongepowered.common.SpongeCatalogType;
import org.spongepowered.common.data.persistence.ConfigurateTranslator;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;

public class HoconDataFormat
extends SpongeCatalogType
implements StringDataFormat {
    public HoconDataFormat(ResourceKey key) {
        super(key);
    }

    @Override
    public DataContainer read(String input) throws InvalidDataException, IOException {
        return HoconDataFormat.readFrom(() -> new BufferedReader(new StringReader(input)));
    }

    @Override
    public DataContainer readFrom(Reader input) throws InvalidDataException, IOException {
        return HoconDataFormat.readFrom(() -> HoconDataFormat.createBufferedReader(input));
    }

    @Override
    public DataContainer readFrom(InputStream input) throws InvalidDataFormatException, IOException {
        return HoconDataFormat.readFrom(() -> new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)));
    }

    private static DataContainer readFrom(Callable<BufferedReader> source) throws InvalidDataFormatException {
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().source(source)).build();
        try {
            CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load();
            return ConfigurateTranslator.instance().translate(node);
        }
        catch (ConfigurateException ex) {
            throw new InvalidDataFormatException(ex);
        }
    }

    @Override
    public String write(DataView data) throws IOException {
        StringWriter writer = new StringWriter();
        HoconDataFormat.writeTo(() -> new BufferedWriter(writer), data);
        return writer.toString();
    }

    @Override
    public void writeTo(Writer output, DataView data) throws IOException {
        HoconDataFormat.writeTo(() -> HoconDataFormat.createBufferedWriter(output), data);
    }

    @Override
    public void writeTo(OutputStream output, DataView data) throws IOException {
        HoconDataFormat.writeTo(() -> new BufferedWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8)), data);
    }

    private static void writeTo(Callable<BufferedWriter> sink, DataView data) throws IOException {
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().sink(sink)).build();
        Object node = loader.createNode();
        ConfigurateTranslator.instance().translateDataToNode((ConfigurationNode)node, data);
        try {
            loader.save((ConfigurationNode)node);
        }
        catch (ConfigurateException ex) {
            throw new IOException(ex);
        }
    }

    private static BufferedReader createBufferedReader(Reader reader) {
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader);
    }

    private static BufferedWriter createBufferedWriter(Writer writer) {
        if (writer instanceof BufferedWriter) {
            return (BufferedWriter)writer;
        }
        return new BufferedWriter(writer);
    }
}

