/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.persistence.datastore;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataStore;
import org.spongepowered.common.data.persistence.datastore.SpongeDataStore;

public final class DataStoreRegistry {
    private final DataStore NO_OP_DATASTORE = new SpongeDataStore(Collections.emptyMap(), Collections.emptyList());
    private final Multimap<Key<?>, DataStore> dataStores = HashMultimap.create();
    private final Map<LookupKey, DataStore> dataStoreCache = new ConcurrentHashMap<LookupKey, DataStore>();

    public void register(DataStore dataStore, Iterable<Key<?>> keys) {
        keys.forEach(k -> this.dataStores.put(k, (Object)dataStore));
        this.dataStoreCache.clear();
    }

    public Collection<DataStore> getDataStores(Key<?> key) {
        return this.dataStores.get(key);
    }

    public DataStore getDataStore(Key<?> key, TypeToken<? extends DataHolder> typeToken) {
        return this.getDataStore(key, typeToken.getType());
    }

    public DataStore getDataStore(Key<?> key, Type typeToken) {
        return this.dataStoreCache.computeIfAbsent(new LookupKey(typeToken, key), this::loadDataStore);
    }

    private DataStore loadDataStore(LookupKey lookupKey) {
        List dataStores = this.dataStores.get((Object)lookupKey.key).stream().filter(ds -> ds.getSupportedTypes().stream().anyMatch(token -> GenericTypeReflector.isSuperType(token, lookupKey.holderType))).collect(Collectors.toList());
        if (dataStores.size() > 1) {
            throw new IllegalStateException("Multiple data-stores registered for the same key (" + lookupKey.key.getKey() + ") and data-holder " + lookupKey.holderType.toString());
        }
        if (dataStores.isEmpty()) {
            dataStores.add(this.NO_OP_DATASTORE);
        }
        return (DataStore)dataStores.get(0);
    }

    private static class LookupKey {
        private final Type holderType;
        private final Key<?> key;

        public LookupKey(Type holderType, Key<?> key) {
            this.holderType = holderType;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LookupKey lookupKey = (LookupKey)o;
            return this.holderType.equals(lookupKey.holderType) && this.key.equals(lookupKey.key);
        }

        public int hashCode() {
            return Objects.hash(this.holderType, this.key);
        }
    }
}

