/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.block.entity;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.spawner.AbstractSpawner;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.animal.Pig;
import org.spongepowered.api.util.weighted.TableEntry;
import org.spongepowered.api.util.weighted.WeightedObject;
import org.spongepowered.api.util.weighted.WeightedSerializableObject;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.common.accessor.tileentity.MobSpawnerTileEntityAccessor;
import org.spongepowered.common.accessor.util.WeightedRandom_ItemAccessor;
import org.spongepowered.common.accessor.world.spawner.AbstractSpawnerAccessor;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.util.SpongeTicks;

public final class MobSpawnerData {
    private MobSpawnerData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(MobSpawnerTileEntityAccessor.class).create(Keys.MAX_NEARBY_ENTITIES).get(h2 -> ((AbstractSpawnerAccessor)h2.accessor$getSpawnerLogic()).accessor$getMaxNearbyEntities())).set((h2, v) -> ((AbstractSpawnerAccessor)h2.accessor$getSpawnerLogic()).accessor$setMaxNearbyEntities((int)v))).create(Keys.MAX_SPAWN_DELAY).get(h2 -> new SpongeTicks(((AbstractSpawnerAccessor)h2.accessor$getSpawnerLogic()).accessor$getMaxSpawnDelay()))).set((h2, v) -> ((AbstractSpawnerAccessor)h2.accessor$getSpawnerLogic()).accessor$setMaxSpawnDelay((int)v.getTicks()))).create(Keys.MIN_SPAWN_DELAY).get(h2 -> new SpongeTicks(((AbstractSpawnerAccessor)h2.accessor$getSpawnerLogic()).accessor$getMinSpawnDelay()))).set((h2, v) -> ((AbstractSpawnerAccessor)h2.accessor$getSpawnerLogic()).accessor$setMinSpawnDelay((int)v.getTicks()))).create(Keys.NEXT_ENTITY_TO_SPAWN).get(h2 -> MobSpawnerData.getNextEntity((AbstractSpawnerAccessor)h2.accessor$getSpawnerLogic()))).set((h2, v) -> MobSpawnerData.setNextEntity(h2.accessor$getSpawnerLogic(), v))).create(Keys.REMAINING_SPAWN_DELAY).get(h2 -> new SpongeTicks(((AbstractSpawnerAccessor)h2.accessor$getSpawnerLogic()).accessor$getSpawnDelay()))).set((h2, v) -> ((AbstractSpawnerAccessor)h2.accessor$getSpawnerLogic()).accessor$setSpawnDelay((int)v.getTicks()))).create(Keys.REQUIRED_PLAYER_RANGE).get(h2 -> ((AbstractSpawnerAccessor)h2.accessor$getSpawnerLogic()).accessor$getActivatingRangeFromPlayer())).set((h2, v) -> ((AbstractSpawnerAccessor)h2.accessor$getSpawnerLogic()).accessor$setActivatingRangeFromPlayer(v.intValue()))).create(Keys.SPAWN_COUNT).get(h2 -> ((AbstractSpawnerAccessor)h2.accessor$getSpawnerLogic()).accessor$getSpawnCount())).set((h2, v) -> ((AbstractSpawnerAccessor)h2.accessor$getSpawnerLogic()).accessor$setSpawnCount((int)v))).create(Keys.SPAWN_RANGE).get(h2 -> ((AbstractSpawnerAccessor)h2.accessor$getSpawnerLogic()).accessor$getSpawnRange())).set((h2, v) -> ((AbstractSpawnerAccessor)h2.accessor$getSpawnerLogic()).accessor$setSpawnRange(v.intValue()))).create(Keys.SPAWNABLE_ENTITIES).get(h2 -> MobSpawnerData.getEntities(h2.accessor$getSpawnerLogic()))).set((h2, v) -> {
            AbstractSpawnerAccessor logic = (AbstractSpawnerAccessor)h2.accessor$getSpawnerLogic();
            MobSpawnerData.setEntities(logic, v);
            MobSpawnerData.setNextEntity((AbstractSpawner)logic, MobSpawnerData.getNextEntity(logic));
        });
    }

    private static WeightedSerializableObject<EntityArchetype> getNextEntity(AbstractSpawnerAccessor logic) {
        int weight = ((WeightedRandom_ItemAccessor)logic.accessor$getSpawnData()).accessor$getItemWeight();
        String resourceLocation = logic.accessor$getSpawnData().getNbt().getString("id");
        EntityType<Pig> type = Registry.ENTITY_TYPE.getValue(new ResourceLocation(resourceLocation)).map(EntityType.class::cast).orElse(EntityTypes.PIG.get());
        CompoundNBT data = logic.accessor$getSpawnData().getNbt();
        EntityArchetype archetype = EntityArchetype.builder().type(type).entityData(NbtTranslator.getInstance().translateFrom(data)).build();
        return new WeightedSerializableObject<EntityArchetype>(archetype, weight);
    }

    private static void setNextEntity(AbstractSpawner logic, WeightedSerializableObject<EntityArchetype> value) {
        CompoundNBT compound = NbtTranslator.getInstance().translate(((EntityArchetype)value.get()).getEntityData());
        if (!compound.contains("id")) {
            ResourceKey key = ((EntityArchetype)value.get()).getType().getKey();
            compound.putString("id", key.toString());
        }
        logic.setNextSpawnData(new WeightedSpawnerEntity((int)value.getWeight(), compound));
    }

    private static WeightedTable<EntityArchetype> getEntities(AbstractSpawner logic) {
        WeightedTable<EntityArchetype> possibleEntities = new WeightedTable<EntityArchetype>();
        for (WeightedSpawnerEntity weightedEntity : ((AbstractSpawnerAccessor)logic).accessor$getPotentialSpawns()) {
            CompoundNBT nbt = weightedEntity.getNbt();
            String resourceLocation = nbt.getString("id");
            EntityType<Pig> type = Registry.ENTITY_TYPE.getValue(new ResourceLocation(resourceLocation)).map(EntityType.class::cast).orElse(EntityTypes.PIG.get());
            EntityArchetype archetype = EntityArchetype.builder().type(type).entityData(NbtTranslator.getInstance().translateFrom(nbt)).build();
            possibleEntities.add((TableEntry<EntityArchetype>)new WeightedSerializableObject<EntityArchetype>(archetype, ((WeightedRandom_ItemAccessor)weightedEntity).accessor$getItemWeight()));
        }
        return possibleEntities;
    }

    private static void setEntities(AbstractSpawnerAccessor logic, WeightedTable<EntityArchetype> table) {
        logic.accessor$getPotentialSpawns().clear();
        for (TableEntry<EntityArchetype> tableEntry : table) {
            if (!(tableEntry instanceof WeightedObject)) continue;
            WeightedObject object = (WeightedObject)tableEntry;
            CompoundNBT compound = NbtTranslator.getInstance().translate(((EntityArchetype)object.get()).getEntityData());
            if (!compound.contains("id")) {
                ResourceKey key = ((EntityArchetype)object.get()).getType().getKey();
                compound.putString("id", key.toString());
            }
            logic.accessor$getPotentialSpawns().add(new WeightedSpawnerEntity((int)tableEntry.getWeight(), compound));
        }
    }
}

