/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.entity;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.math.Rotations;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.type.BodyPart;
import org.spongepowered.api.data.type.BodyParts;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.item.inventory.equipment.EquipmentTypes;
import org.spongepowered.common.accessor.entity.item.ArmorStandEntityAccessor;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

public final class ArmorStandData {
    private ArmorStandData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(ArmorStandEntity.class).create(Keys.BODY_ROTATIONS).get(h2 -> {
            HashMap<BodyPart, Vector3d> values = new HashMap<BodyPart, Vector3d>();
            values.put(BodyParts.HEAD.get(), VecHelper.toVector3d(h2.getHeadRotation()));
            values.put(BodyParts.CHEST.get(), VecHelper.toVector3d(h2.getBodyRotation()));
            values.put(BodyParts.LEFT_ARM.get(), VecHelper.toVector3d(((ArmorStandEntityAccessor)h2).accessor$getLeftArmRotation()));
            values.put(BodyParts.RIGHT_ARM.get(), VecHelper.toVector3d(((ArmorStandEntityAccessor)h2).accessor$getRightArmRotation()));
            values.put(BodyParts.LEFT_LEG.get(), VecHelper.toVector3d(((ArmorStandEntityAccessor)h2).accessor$getLeftLegRotation()));
            values.put(BodyParts.RIGHT_LEG.get(), VecHelper.toVector3d(((ArmorStandEntityAccessor)h2).accessor$getRightLegRotation()));
            return values;
        })).set((h2, v) -> {
            ArmorStandData.apply(v, BodyParts.HEAD.get(), arg_0 -> ((ArmorStandEntity)h2).setHeadRotation(arg_0));
            ArmorStandData.apply(v, BodyParts.CHEST.get(), arg_0 -> ((ArmorStandEntity)h2).setBodyRotation(arg_0));
            ArmorStandData.apply(v, BodyParts.LEFT_ARM.get(), arg_0 -> ((ArmorStandEntity)h2).setLeftArmRotation(arg_0));
            ArmorStandData.apply(v, BodyParts.RIGHT_ARM.get(), arg_0 -> ((ArmorStandEntity)h2).setRightArmRotation(arg_0));
            ArmorStandData.apply(v, BodyParts.LEFT_LEG.get(), arg_0 -> ((ArmorStandEntity)h2).setLeftLegRotation(arg_0));
            ArmorStandData.apply(v, BodyParts.RIGHT_LEG.get(), arg_0 -> ((ArmorStandEntity)h2).setRightLegRotation(arg_0));
        })).create(Keys.CHEST_ROTATION).get(h2 -> VecHelper.toVector3d(h2.getBodyRotation()))).set((h2, v) -> h2.setBodyRotation(VecHelper.toRotation(v)))).create(Keys.HAS_ARMS).get(ArmorStandEntity::getShowArms)).set((h2, v) -> ((ArmorStandEntityAccessor)h2).accessor$setShowArms((boolean)v))).create(Keys.HAS_BASE_PLATE).get(h2 -> !h2.hasNoBasePlate())).set((h2, v) -> ((ArmorStandEntityAccessor)h2).accessor$setNoBasePlate(v == false))).create(Keys.HAS_MARKER).get(ArmorStandEntity::hasMarker)).set((h2, v) -> ((ArmorStandEntityAccessor)h2).accessor$setMarker((boolean)v))).create(Keys.HEAD_ROTATION).get(h2 -> VecHelper.toVector3d(h2.getHeadRotation()))).set((h2, v) -> h2.setHeadRotation(VecHelper.toRotation(v)))).create(Keys.IS_PLACING_DISABLED).get(h2 -> Sponge.getRegistry().getCatalogRegistry().streamAllOf(EquipmentType.class).filter(t -> t instanceof EquipmentSlotType).collect(Collectors.toMap(t -> t, t -> ((ArmorStandEntityAccessor)h2).accessor$isDisabled((EquipmentSlotType)t))))).set((h2, v) -> {
            int chunk = 0;
            int disabledSlots = ((ArmorStandEntityAccessor)h2).accessor$getDisabledSlots();
            int allChunk = disabledSlots & 0xFF;
            if (allChunk != 0) {
                disabledSlots |= allChunk << 16;
                disabledSlots ^= 0xFF;
            }
            if (((Boolean)v.get(EquipmentTypes.FEET.get())).booleanValue()) {
                chunk |= 2;
            }
            if (((Boolean)v.get(EquipmentTypes.LEGS.get())).booleanValue()) {
                chunk |= 4;
            }
            if (((Boolean)v.get(EquipmentTypes.CHEST.get())).booleanValue()) {
                chunk |= 8;
            }
            if (((Boolean)v.get(EquipmentTypes.HEAD.get())).booleanValue()) {
                chunk |= 0x10;
            }
            ((ArmorStandEntityAccessor)h2).accessor$setDisabledSlots(disabledSlots |= chunk << 16);
        })).create(Keys.IS_SMALL).get(ArmorStandEntity::isSmall)).set((h2, v) -> ((ArmorStandEntityAccessor)h2).accessor$setSmall((boolean)v))).create(Keys.IS_TAKING_DISABLED).get(h2 -> {
            int disabled = ((ArmorStandEntityAccessor)h2).accessor$getDisabledSlots();
            int resultantChunk = disabled >> 16 & 0xFF | disabled & 0xFF;
            return ImmutableMap.of((Object)EquipmentTypes.FEET.get(), (Object)((resultantChunk & 2) != 0 ? 1 : 0), (Object)EquipmentTypes.LEGS.get(), (Object)((resultantChunk & 4) != 0 ? 1 : 0), (Object)EquipmentTypes.CHEST.get(), (Object)((resultantChunk & 8) != 0 ? 1 : 0), (Object)EquipmentTypes.HEAD.get(), (Object)((resultantChunk & 0x10) != 0 ? 1 : 0));
        })).set((h2, v) -> {
            int chunk = 0;
            int disabledSlots = ((ArmorStandEntityAccessor)h2).accessor$getDisabledSlots();
            int allChunk = disabledSlots & 0xFF;
            if (allChunk != 0) {
                disabledSlots |= allChunk << 16;
                ((ArmorStandEntityAccessor)h2).accessor$setDisabledSlots(disabledSlots ^= 0xFF);
            }
            if (((Boolean)v.get(EquipmentTypes.FEET.get())).booleanValue()) {
                chunk |= 2;
            }
            if (((Boolean)v.get(EquipmentTypes.LEGS.get())).booleanValue()) {
                chunk |= 4;
            }
            if (((Boolean)v.get(EquipmentTypes.CHEST.get())).booleanValue()) {
                chunk |= 8;
            }
            if (((Boolean)v.get(EquipmentTypes.HEAD.get())).booleanValue()) {
                chunk |= 0x10;
            }
            ((ArmorStandEntityAccessor)h2).accessor$setDisabledSlots(disabledSlots |= chunk << 8);
        })).create(Keys.LEFT_ARM_ROTATION).get(h2 -> VecHelper.toVector3d(h2.getLeftArmRotation()))).set((h2, v) -> h2.setLeftArmRotation(VecHelper.toRotation(v)))).create(Keys.LEFT_LEG_ROTATION).get(h2 -> VecHelper.toVector3d(h2.getLeftLegRotation()))).set((h2, v) -> h2.setLeftLegRotation(VecHelper.toRotation(v)))).create(Keys.RIGHT_ARM_ROTATION).get(h2 -> VecHelper.toVector3d(h2.getRightArmRotation()))).set((h2, v) -> h2.setRightArmRotation(VecHelper.toRotation(v)))).create(Keys.RIGHT_LEG_ROTATION).get(h2 -> VecHelper.toVector3d(h2.getRightLegRotation()))).set((h2, v) -> h2.setRightLegRotation(VecHelper.toRotation(v)));
    }

    private static void apply(Map<BodyPart, Vector3d> value, BodyPart part, Consumer<Rotations> consumer) {
        Vector3d vec = value.get(part);
        if (vec == null) {
            return;
        }
        consumer.accept(VecHelper.toRotation(vec));
    }
}

