/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.entity;

import java.util.ArrayList;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SDestroyEntitiesPacket;
import net.minecraft.network.play.server.SSpawnPaintingPacket;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.type.ArtType;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.entity.item.HangingEntityAccessor;
import org.spongepowered.common.accessor.world.server.ChunkManagerAccessor;
import org.spongepowered.common.accessor.world.server.EntityTrackerAccessor;
import org.spongepowered.common.config.SpongeGameConfigs;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.util.SpongeTicks;

public final class PaintingData {
    private PaintingData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)registrator.asMutable(PaintingEntity.class).create(Keys.ART_TYPE).get(h2 -> (ArtType)h2.art)).setAnd((h2, v) -> {
            if (!h2.world.isRemote) {
                PaintingType oldArt = h2.art;
                h2.art = (PaintingType)v;
                ((HangingEntityAccessor)h2).accessor$updateFacingWithBoundingBox(h2.getHorizontalFacing());
                if (!h2.onValidSurface()) {
                    h2.art = oldArt;
                    ((HangingEntityAccessor)h2).accessor$updateFacingWithBoundingBox(h2.getHorizontalFacing());
                    return false;
                }
                ChunkManagerAccessor chunkManager = (ChunkManagerAccessor)((ServerWorld)h2.world).getChunkProvider().chunkManager;
                EntityTrackerAccessor paintingTracker = (EntityTrackerAccessor)chunkManager.accessor$getEntityTrackers().get(h2.getEntityId());
                if (paintingTracker == null) {
                    return true;
                }
                ArrayList<ServerPlayerEntity> players = new ArrayList<ServerPlayerEntity>();
                for (ServerPlayerEntity player : paintingTracker.accessor$getTrackingPlayers()) {
                    SDestroyEntitiesPacket packet = new SDestroyEntitiesPacket(new int[]{h2.getEntityId()});
                    player.connection.sendPacket((IPacket)packet);
                    players.add(player);
                }
                for (ServerPlayerEntity player : players) {
                    SpongeCommon.getServerScheduler().submit(Task.builder().plugin(((Launch)Launch.getInstance()).getCommonPlugin()).delay(new SpongeTicks(((WorldConfig)SpongeGameConfigs.getForWorld(h2.world).get()).getEntity().getPaintingRespawnDelay())).execute(() -> {
                        SSpawnPaintingPacket packet = new SSpawnPaintingPacket(h2);
                        player.connection.sendPacket((IPacket)packet);
                    }).build());
                }
                return true;
            }
            return true;
        });
    }
}

