/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.item.stack;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import org.spongepowered.api.data.Keys;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.util.NBTCollectors;

public final class BookItemStackData {
    private BookItemStackData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(ItemStack.class).create(Keys.AUTHOR).get(h2 -> {
            CompoundNBT tag = h2.getTag();
            if (tag == null) {
                return null;
            }
            return SpongeAdventure.legacySection(tag.getString("author"));
        })).set((h2, v) -> h2.setTagInfo("author", (INBT)StringNBT.valueOf((String)SpongeAdventure.legacySection(v))))).supports(h2 -> h2.getItem() == Items.WRITTEN_BOOK)).create(Keys.GENERATION).get(h2 -> {
            CompoundNBT tag = h2.getTag();
            if (tag == null) {
                return null;
            }
            return tag.getInt("generation");
        })).setAnd((h2, v) -> {
            if (v < 0) {
                return false;
            }
            h2.setTagInfo("generation", (INBT)IntNBT.valueOf((int)v));
            return true;
        })).supports(h2 -> h2.getItem() == Items.WRITTEN_BOOK)).create(Keys.PAGES).get(h2 -> BookItemStackData.get(h2, iv -> GsonComponentSerializer.gson().deserialize(iv)))).setAnd((h2, v) -> BookItemStackData.set(h2, v, ih -> (String)GsonComponentSerializer.gson().serialize(ih)))).deleteAnd(BookItemStackData::delete)).supports(h2 -> h2.getItem() == Items.WRITTEN_BOOK)).create(Keys.PLAIN_PAGES).get(h2 -> BookItemStackData.get(h2, iv -> iv))).setAnd((h2, v) -> BookItemStackData.set(h2, v, iv -> iv))).deleteAnd(BookItemStackData::delete)).supports(h2 -> h2.getItem() == Items.WRITABLE_BOOK);
    }

    private static <V> List<V> get(ItemStack holder, Function<String, V> predicate) {
        CompoundNBT tag = holder.getTag();
        if (tag == null || !tag.contains("pages")) {
            return null;
        }
        ListNBT list = tag.getList("pages", 8);
        return list.stream().map(INBT::getString).map(predicate).collect(Collectors.toList());
    }

    private static <V> boolean set(ItemStack holder, List<V> value, Function<V, String> predicate) {
        ListNBT list = value.stream().map(predicate).collect(NBTCollectors.toStringTagList());
        holder.setTagInfo("pages", (INBT)list);
        CompoundNBT compound = holder.getOrCreateTag();
        if (!compound.contains("title")) {
            compound.putString("title", "invalid");
        }
        if (!compound.contains("author")) {
            compound.putString("author", "invalid");
        }
        compound.putBoolean("resolved", true);
        return false;
    }

    private static boolean delete(ItemStack holder) {
        CompoundNBT tag = holder.getTag();
        if (tag != null && tag.contains("pages", 9)) {
            tag.remove("pages");
            return true;
        }
        return false;
    }
}

