/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.item.stack;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Keys;
import org.spongepowered.common.data.provider.DataProviderRegistrator;

public final class HideFlagsItemStackData {
    private static final int NBTKeyHideAttributesFlag = 2;
    private static final int NBTKeyHideCanDestroyFlag = 8;
    private static final int NBTKeyHideCanPlaceFlag = 16;
    private static final int NBTKeyHideEnchantmentsFlag = 1;
    private static final int NBTKeyHideMiscellaneousFlag = 32;
    private static final int NBTKeyHideUnbreakableFlag = 4;

    private HideFlagsItemStackData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(ItemStack.class).create(Keys.HIDE_ATTRIBUTES).get(h2 -> HideFlagsItemStackData.get(h2, 2))).set((h2, v) -> HideFlagsItemStackData.set(h2, v, 2))).create(Keys.HIDE_CAN_DESTROY).get(h2 -> HideFlagsItemStackData.get(h2, 8))).set((h2, v) -> HideFlagsItemStackData.set(h2, v, 8))).create(Keys.HIDE_CAN_PLACE).get(h2 -> HideFlagsItemStackData.get(h2, 16))).set((h2, v) -> HideFlagsItemStackData.set(h2, v, 16))).create(Keys.HIDE_ENCHANTMENTS).get(h2 -> HideFlagsItemStackData.get(h2, 1))).set((h2, v) -> HideFlagsItemStackData.set(h2, v, 1))).create(Keys.HIDE_MISCELLANEOUS).get(h2 -> HideFlagsItemStackData.get(h2, 32))).set((h2, v) -> HideFlagsItemStackData.set(h2, v, 32))).create(Keys.HIDE_UNBREAKABLE).get(h2 -> HideFlagsItemStackData.get(h2, 4))).set((h2, v) -> HideFlagsItemStackData.set(h2, v, 4));
    }

    private static boolean get(ItemStack holder, int flag) {
        @Nullable CompoundNBT tag = holder.getTag();
        if (tag != null && tag.contains("HideFlags", 3)) {
            int tagFlag = tag.getInt("HideFlags");
            return (tagFlag & flag) != 0;
        }
        return false;
    }

    private static boolean set(ItemStack holder, Boolean value, int flag) {
        CompoundNBT tag = holder.getOrCreateTag();
        if (tag.contains("HideFlags", 3)) {
            int tagFlag = tag.getInt("HideFlags");
            if (value.booleanValue()) {
                tag.putInt("HideFlags", tagFlag | flag);
            } else {
                int flags = tagFlag & ~flag;
                if (flags == 0) {
                    tag.remove("HideFlags");
                } else {
                    tag.putInt("HideFlags", flags);
                }
            }
        } else if (value.booleanValue()) {
            tag.putInt("HideFlags", flag);
        }
        return true;
    }
}

