/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.item.stack;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import org.spongepowered.api.data.Keys;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.data.provider.DataProviderRegistrator;

public final class SignItemStackData {
    private SignItemStackData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(ItemStack.class).create(Keys.SIGN_LINES).get(h2 -> {
            CompoundNBT tag = h2.getChildTag("BlockEntityTag");
            if (tag == null) {
                return null;
            }
            String id = tag.getString("id");
            if (!id.equalsIgnoreCase("Sign")) {
                return null;
            }
            ArrayList texts = Lists.newArrayListWithCapacity((int)4);
            for (int i = 0; i < 4; ++i) {
                texts.add(SpongeAdventure.json(tag.getString("Text" + (i + 1))));
            }
            return texts;
        })).set((h2, v) -> {
            CompoundNBT tag = h2.getOrCreateChildTag("BlockEntityTag");
            tag.putString("id", "Sign");
            for (int i = 0; i < 4; ++i) {
                TextComponent line;
                Object object = line = v.size() > i ? (Component)v.get(i) : Component.empty();
                if (line == null) {
                    throw new IllegalArgumentException("A null line was given at index " + i);
                }
                tag.putString("Text" + (i + 1), SpongeAdventure.json((Component)line));
            }
        })).delete(h2 -> h2.removeChildTag("BlockEntityTag"));
    }
}

