/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.effect.particle;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.particle.ParticleOption;
import org.spongepowered.api.effect.particle.ParticleType;
import org.spongepowered.common.SpongeCatalogType;

public final class NumericalParticleType
extends SpongeCatalogType
implements ParticleType {
    private final int id;
    private final Map<ParticleOption<?>, Object> defaultOptions;
    private final @Nullable DataCalculator dataCalculator;

    public NumericalParticleType(int id, ResourceKey key, Map<ParticleOption<?>, Object> defaultOptions, @Nullable DataCalculator dataCalculator) {
        super(key);
        this.id = id;
        this.defaultOptions = ImmutableMap.copyOf(defaultOptions);
        this.dataCalculator = dataCalculator;
    }

    public NumericalParticleType(int id, ResourceKey key) {
        super(key);
        this.id = id;
        this.defaultOptions = ImmutableMap.of();
        this.dataCalculator = null;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public <V> Optional<V> getDefaultOption(ParticleOption<V> option) {
        return Optional.ofNullable(this.defaultOptions.get(option));
    }

    @Override
    public Map<ParticleOption<?>, Object> getDefaultOptions() {
        return this.defaultOptions;
    }

    public int getData(ParticleEffect effect) {
        if (this.dataCalculator == null) {
            return 0;
        }
        return this.dataCalculator.getData(effect);
    }

    public static interface DataCalculator {
        public int getData(ParticleEffect var1);
    }
}

