/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.projectile;

import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.ProxyBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.api.block.entity.carrier.Dispenser;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.common.accessor.block.DispenserBlockAccessor;
import org.spongepowered.common.entity.projectile.ProjectileLogic;
import org.spongepowered.common.entity.projectile.ProjectileSourceLogic;

public final class DispenserSourceLogic
implements ProjectileSourceLogic<Dispenser> {
    DispenserSourceLogic() {
    }

    @Override
    public <P extends Projectile> Optional<P> launch(ProjectileLogic<P> logic, Dispenser source, EntityType<P> projectileType, Object ... args) {
        if (args.length == 1 && args[0] instanceof Item) {
            return this.launch((DispenserTileEntity)source, projectileType, (Item)args[0]);
        }
        Optional<P> projectile = logic.createProjectile(source, projectileType, source.getLocation());
        if (projectile.isPresent()) {
            Direction enumfacing = DispenserSourceLogic.getFacing((DispenserTileEntity)source);
            Entity projectileEntity = (Entity)projectile.get();
            BlockPos adjustedPosition = projectileEntity.getPosition().add(enumfacing.getDirectionVec());
            projectileEntity.setPosition((double)adjustedPosition.getX(), (double)adjustedPosition.getY(), (double)adjustedPosition.getZ());
        }
        return projectile;
    }

    public static Direction getFacing(DispenserTileEntity dispenser) {
        BlockState state = dispenser.getWorld().getBlockState(dispenser.getPos());
        return (Direction)state.get((IProperty)DispenserBlock.FACING);
    }

    private <P extends Projectile> Optional<P> launch(DispenserTileEntity dispenser, EntityType<P> projectileType, Item item) {
        IDispenseItemBehavior behavior = DispenserBlockAccessor.accessor$DISPENSE_BEHAVIOR_REGISTRY().get(item);
        ServerWorld world = (ServerWorld)dispenser.getWorld();
        behavior.dispense((IBlockSource)new ProxyBlockSource((World)world, dispenser.getPos()), new ItemStack((IItemProvider)item));
        List entities = world.getEntities((net.minecraft.entity.EntityType)projectileType, entity -> true);
        if (entities.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((Projectile)entities.get(entities.size() - 1));
    }
}

