/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.cause.entity.damage;

import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import net.minecraft.entity.item.FallingBlockEntity;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.FallingBlock;
import org.spongepowered.api.event.cause.entity.damage.source.FallingBlockDamageSource;
import org.spongepowered.api.event.cause.entity.damage.source.common.AbstractDamageSourceBuilder;
import org.spongepowered.common.accessor.util.DamageSourceAccessor;
import org.spongepowered.common.util.MinecraftFallingBlockDamageSource;

public final class SpongeFallingBlockDamgeSourceBuilder
extends AbstractDamageSourceBuilder<FallingBlockDamageSource, FallingBlockDamageSource.Builder>
implements FallingBlockDamageSource.Builder {
    protected WeakReference<Entity> reference = null;

    @Override
    public SpongeFallingBlockDamgeSourceBuilder entity(Entity entity) {
        Preconditions.checkArgument((boolean)(entity instanceof FallingBlock));
        this.reference = new WeakReference<Entity>(entity);
        return this;
    }

    @Override
    public FallingBlockDamageSource.Builder fire() {
        return null;
    }

    @Override
    public FallingBlockDamageSource build() throws IllegalStateException {
        Preconditions.checkState((this.reference.get() != null ? 1 : 0) != 0);
        Preconditions.checkState((this.damageType != null ? 1 : 0) != 0);
        MinecraftFallingBlockDamageSource damageSource = new MinecraftFallingBlockDamageSource(this.damageType.getKey().getFormatted(), (FallingBlockEntity)this.reference.get());
        DamageSourceAccessor accessor = (DamageSourceAccessor)((Object)damageSource);
        if (this.creative) {
            accessor.accessor$setDamageAllowedInCreativeMode();
        }
        if (this.scales) {
            damageSource.setDifficultyScaled();
        }
        if (this.magical) {
            damageSource.setMagicDamage();
        }
        if (this.bypasses) {
            accessor.accessor$setDamageBypassesArmor();
        }
        if (this.absolute) {
            accessor.accessor$setDamageIsAbsolute();
        }
        if (this.explosion) {
            damageSource.setExplosion();
        }
        if (this.exhaustion != null) {
            accessor.accessor$setHungerDamage(this.exhaustion.floatValue());
        }
        return (FallingBlockDamageSource)((Object)damageSource);
    }

    @Override
    public FallingBlockDamageSource.Builder from(FallingBlockDamageSource value) {
        super.from(value);
        this.reference = new WeakReference<FallingBlock>(value.getSource());
        return this;
    }

    @Override
    public SpongeFallingBlockDamgeSourceBuilder reset() {
        super.reset();
        this.reference = null;
        return this;
    }

    @Override
    public FallingBlockDamageSource.Builder places(boolean canPlace) {
        throw new UnsupportedOperationException("implement me");
    }

    @Override
    public FallingBlockDamageSource.Builder fallTime(int time) {
        throw new UnsupportedOperationException("implement me");
    }

    @Override
    public FallingBlockDamageSource.Builder hurtsEntities(boolean hurts) {
        throw new UnsupportedOperationException("implement me");
    }

    @Override
    public FallingBlockDamageSource.Builder maxDamage(double damage) {
        throw new UnsupportedOperationException("implement me");
    }

    @Override
    public FallingBlockDamageSource.Builder damagePerBlock(double damagePer) {
        throw new UnsupportedOperationException("implement me");
    }
}

