/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.lifecycle;

import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Game;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.lifecycle.RegisterCatalogRegistryEvent;
import org.spongepowered.api.registry.DuplicateRegistrationException;
import org.spongepowered.common.event.lifecycle.AbstractLifecycleEvent;
import org.spongepowered.common.registry.SpongeCatalogRegistry;

public final class RegisterCatalogRegistryEventImpl
extends AbstractLifecycleEvent
implements RegisterCatalogRegistryEvent {
    public RegisterCatalogRegistryEventImpl(Cause cause, Game game) {
        super(cause, game);
    }

    @Override
    public <T extends CatalogType> void register(Class<T> catalogClass, ResourceKey key) throws DuplicateRegistrationException {
        Preconditions.checkNotNull((Object)key);
        ((SpongeCatalogRegistry)Sponge.getRegistry().getCatalogRegistry()).registerRegistry(catalogClass, key, true);
    }

    @Override
    public <T extends CatalogType> void register(Class<T> catalogClass, ResourceKey key, @Nullable Supplier<Set<T>> defaultsSupplier) throws DuplicateRegistrationException {
        Preconditions.checkNotNull((Object)key);
        ((SpongeCatalogRegistry)Sponge.getRegistry().getCatalogRegistry()).registerRegistry(catalogClass, key, defaultsSupplier, false, true, true);
    }

    public String toString() {
        return "RegisterCatalogRegistryEvent{cause=" + this.cause + "}";
    }
}

