/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction;

import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.block.BlockEventData;
import net.minecraft.block.BlockState;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.common.accessor.world.server.ServerWorldAccessor;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.block.TrackerBlockEventDataBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.BlockEventBasedTransaction;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.util.PrettyPrinter;

public class AddBlockEventTransaction
extends BlockEventBasedTransaction {
    private final BlockEventData blockEvent;
    private final SpongeBlockSnapshot original;

    AddBlockEventTransaction(SpongeBlockSnapshot original, TrackerBlockEventDataBridge blockEvent) {
        super(original.getBlockPos(), (BlockState)original.getState(), original.getWorld());
        this.blockEvent = (BlockEventData)blockEvent;
        this.original = original;
    }

    @Override
    protected SpongeBlockSnapshot getResultingSnapshot() {
        return this.getOriginalSnapshot();
    }

    @Override
    protected SpongeBlockSnapshot getOriginalSnapshot() {
        return this.original;
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.empty();
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
        printer.add("AddBlockEvent").add(" %s : %s", "Original Block", this.original).add(" %s : %s", "Original State", this.originalState).add(" %s : %s", "EventData", this.blockEvent);
    }

    @Override
    public void restore() {
        this.original.getServerWorld().ifPresent(world -> ((ServerWorldAccessor)world).accessor$getBlockEventQueue().remove((Object)this.blockEvent));
    }
}

