/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.HarvestEntityEvent;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionType;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionTypes;
import org.spongepowered.common.util.PrettyPrinter;

public final class EntityPerformingDropsTransaction
extends GameTransaction<HarvestEntityEvent> {
    final Supplier<net.minecraft.world.server.ServerWorld> worldSupplier;
    final Entity destroyingEntity;
    final CompoundNBT entityTag;
    final Supplier<Optional<DamageSource>> lastAttacker;

    EntityPerformingDropsTransaction(Supplier<net.minecraft.world.server.ServerWorld> worldSupplier, Entity destroyingEntity, CompoundNBT entityTag, Supplier<Optional<DamageSource>> lastAttacker) {
        super(TransactionTypes.ENTITY_DEATH_DROPS.get(), ((ServerWorld)worldSupplier.get()).getKey());
        this.worldSupplier = worldSupplier;
        this.destroyingEntity = destroyingEntity;
        this.entityTag = entityTag;
        this.lastAttacker = lastAttacker;
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.of((context, stackFrame) -> {
            stackFrame.pushCause(this.destroyingEntity);
            this.lastAttacker.get().ifPresent(attacker -> stackFrame.addContext(EventContextKeys.LAST_DAMAGE_SOURCE, attacker));
        });
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
    }

    @Override
    public boolean acceptEntityDrops(Entity entity) {
        return this.destroyingEntity == entity;
    }

    @Override
    public boolean isUnbatchable() {
        return true;
    }

    @Override
    public Optional<HarvestEntityEvent> generateEvent(PhaseContext<@NonNull ?> context, @Nullable GameTransaction<@NonNull ?> parent, ImmutableList<GameTransaction<HarvestEntityEvent>> gameTransactions, Cause currentCause, ImmutableMultimap.Builder<TransactionType, ? extends Event> transactionPostEventBuilder) {
        return Optional.of(SpongeEventFactory.createHarvestEntityEvent(currentCause, (org.spongepowered.api.entity.Entity)this.destroyingEntity));
    }

    @Override
    public void restore() {
        this.destroyingEntity.getType().spawn((World)this.worldSupplier.get(), this.entityTag, null, null, this.destroyingEntity.getPosition(), SpawnReason.COMMAND, false, false);
    }

    @Override
    public boolean markCancelledTransactions(HarvestEntityEvent event, ImmutableList<? extends GameTransaction<HarvestEntityEvent>> gameTransactions) {
        return false;
    }
}

