/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.effect;

import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class AddBlockLootDropsEffect
implements ProcessingSideEffect {
    public static AddBlockLootDropsEffect getInstance() {
        return Holder.INSTANCE;
    }

    AddBlockLootDropsEffect() {
    }

    @Override
    public EffectResult processSideEffect(BlockPipeline pipeline, PipelineCursor oldState, BlockState newState, SpongeBlockChangeFlag flag) {
        PhaseContext<@NonNull ?> phaseContext = PhaseTracker.getInstance().getPhaseContext();
        ServerWorld world = pipeline.getServerWorld();
        @Nullable TileEntity existingTile = oldState.tileEntity;
        BlockPos pos = oldState.pos;
        LootContext.Builder lootBuilder = new LootContext.Builder(world).withRandom(world.rand).withParameter(LootParameters.POSITION, (Object)pos).withParameter(LootParameters.TOOL, (Object)ItemStack.EMPTY).withNullableParameter(LootParameters.BLOCK_ENTITY, (Object)existingTile);
        phaseContext.state.populateLootContext(phaseContext, lootBuilder);
        return new EffectResult(newState, oldState.state.getDrops(lootBuilder), false);
    }

    private static final class Holder {
        static final AddBlockLootDropsEffect INSTANCE = new AddBlockLootDropsEffect();

        private Holder() {
        }
    }
}

