/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.effect;

import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.chunk.Chunk;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.bridge.block.BlockStateBridge;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class RefreshOldTileEntityOnChunkChangeEffect
implements ProcessingSideEffect {
    RefreshOldTileEntityOnChunkChangeEffect() {
    }

    public static RefreshOldTileEntityOnChunkChangeEffect getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public EffectResult processSideEffect(BlockPipeline pipeline, PipelineCursor oldState, BlockState newState, SpongeBlockChangeFlag flag) {
        @Nullable TileEntity existing = pipeline.getAffectedChunk().getTileEntity(oldState.pos, Chunk.CreateEntityType.CHECK);
        if (((BlockStateBridge)oldState.state).bridge$hasTileEntity() && existing != null) {
            existing.updateContainingBlockInfo();
        }
        return EffectResult.NULL_PASS;
    }

    private static final class Holder {
        static final RefreshOldTileEntityOnChunkChangeEffect INSTANCE = new RefreshOldTileEntityOnChunkChangeEffect();

        private Holder() {
        }
    }
}

