/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.effect;

import java.util.Iterator;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.accessor.world.WorldAccessor;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class RemoveProposedTileEntitiesDuringSetIfWorldProcessingEffect
implements ProcessingSideEffect {
    public static RemoveProposedTileEntitiesDuringSetIfWorldProcessingEffect getInstance() {
        return Holder.INSTANCE;
    }

    RemoveProposedTileEntitiesDuringSetIfWorldProcessingEffect() {
    }

    @Override
    public EffectResult processSideEffect(BlockPipeline pipeline, PipelineCursor oldState, BlockState newState, SpongeBlockChangeFlag flag) {
        ServerWorld serverWorld = pipeline.getServerWorld();
        @Nullable TileEntity tileEntity = oldState.tileEntity;
        BlockPos pos = oldState.pos;
        if (tileEntity == null || tileEntity.isRemoved()) {
            return EffectResult.NULL_RETURN;
        }
        if (((WorldAccessor)serverWorld).accessor$getProcessingLoadedTiles()) {
            Iterator<TileEntity> iterator = ((WorldAccessor)serverWorld).accessor$getAddedTileEntityList().iterator();
            while (iterator.hasNext()) {
                TileEntity tileentity = iterator.next();
                if (!tileentity.getPos().equals((Object)pos)) continue;
                tileentity.remove();
                iterator.remove();
            }
            serverWorld.loadedTileEntityList.add(tileEntity);
            return EffectResult.NULL_RETURN;
        }
        return EffectResult.NULL_PASS;
    }

    private static final class Holder {
        static final RemoveProposedTileEntitiesDuringSetIfWorldProcessingEffect INSTANCE = new RemoveProposedTileEntitiesDuringSetIfWorldProcessingEffect();

        private Holder() {
        }
    }
}

