/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.type;

import java.util.Collection;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.event.Event;

public abstract class TransactionType<E extends Event>
implements CatalogType {
    private final boolean isPrimary;
    private final String name;
    protected final Marker marker;
    private final ResourceKey key;

    TransactionType(ResourceKey key, boolean isPrimary, String name) {
        this.isPrimary = isPrimary;
        this.name = name;
        this.key = key;
        this.marker = MarkerManager.getMarker(this.name);
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public boolean isSecondary() {
        return !this.isPrimary;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return new StringJoiner(", ", TransactionType.class.getSimpleName() + "[", "]").add("isPrimary=" + this.isPrimary).add("name='" + this.name + "'").toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionType that = (TransactionType)o;
        return this.isPrimary == that.isPrimary && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.isPrimary, this.name);
    }

    public void createAndProcessPostEvents(Collection<? extends E> events) {
        this.consumeEventsAndMarker(events, this.marker);
    }

    protected void consumeEventsAndMarker(Collection<? extends E> events, Marker marker) {
    }

    @Override
    public ResourceKey getKey() {
        return this.key;
    }
}

