/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.general;

import com.google.common.collect.ImmutableList;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.world.Explosion;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.accessor.world.ExplosionAccessor;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.ChangeBlock;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.SpawnEntityTransaction;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.general.GeneralState;

final class ExplosionState
extends GeneralState<ExplosionContext> {
    private final BiConsumer<CauseStackManager.StackFrame, ExplosionContext> EXPLOSION_MODIFIER = super.getFrameModifier().andThen((frame, context) -> {
        Entity exploder;
        Explosion explosion = context.getExplosion();
        @Nullable LivingEntity placedBy = explosion.getExplosivePlacedBy();
        if (placedBy != null) {
            if (placedBy instanceof CreatorTrackedBridge) {
                ((CreatorTrackedBridge)placedBy).tracked$getCreatorReference().ifPresent(creator -> frame.addContext(EventContextKeys.CREATOR, creator));
                ((CreatorTrackedBridge)placedBy).tracked$getNotifierReference().ifPresent(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
            }
            frame.addContext(EventContextKeys.IGNITER, (Living)placedBy);
        }
        if ((exploder = ((ExplosionAccessor)explosion).accessor$getExploder()) != null) {
            frame.pushCause(exploder);
        }
        frame.pushCause(explosion);
    });

    ExplosionState() {
    }

    @Override
    public ExplosionContext createNewContext(PhaseTracker tracker) {
        return ((ExplosionContext)((ExplosionContext)((ExplosionContext)new ExplosionContext(tracker).addEntityCaptures()).addEntityDropCaptures()).addBlockCaptures()).populateFromCurrentState();
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, ExplosionContext> getFrameModifier() {
        return this.EXPLOSION_MODIFIER;
    }

    @Override
    public boolean alreadyCapturingEntitySpawns() {
        return true;
    }

    @Override
    public void populateLootContext(ExplosionContext phaseContext, LootContext.Builder lootBuilder) {
        Explosion explosion = phaseContext.getExplosion();
        lootBuilder.withNullableParameter(LootParameters.THIS_ENTITY, (Object)((ExplosionAccessor)explosion).accessor$getExploder());
        if (((ExplosionAccessor)explosion).accessor$getMode() == Explosion.Mode.DESTROY) {
            lootBuilder.withParameter(LootParameters.EXPLOSION_RADIUS, (Object)Float.valueOf(((ExplosionAccessor)explosion).accessor$getSize()));
        }
    }

    @Override
    public void unwind(ExplosionContext context) {
        TrackingUtil.processBlockCaptures(context);
    }

    @Override
    public SpawnEntityEvent createSpawnEvent(ExplosionContext context, GameTransaction<@NonNull ?> parent, ImmutableList<Tuple<Entity, SpawnEntityTransaction.DummySnapshot>> collect, Cause currentCause) {
        if (parent instanceof ChangeBlock) {
            return SpongeEventFactory.createDropItemEventDestruct(currentCause, collect.stream().map(t -> (org.spongepowered.api.entity.Entity)t.getFirst()).collect(Collectors.toList()));
        }
        return super.createSpawnEvent(context, parent, collect, currentCause);
    }
}

