/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.generation;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PooledPhaseState;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.generation.GenerationContext;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickContext;

abstract class GeneralGenerationPhaseState<G extends GenerationContext<G>>
extends PooledPhaseState<G>
implements IPhaseState<G> {
    private Set<IPhaseState<?>> compatibleStates = new HashSet();
    private boolean isBaked = false;
    private final String id;
    private final String desc;

    GeneralGenerationPhaseState(String id) {
        this.id = id;
        this.desc = TrackingUtil.phaseStateToString("Generation", id, this);
    }

    final GeneralGenerationPhaseState addCompatibleState(IPhaseState<?> state) {
        if (this.isBaked) {
            throw new IllegalStateException("This state is already baked! " + this.id);
        }
        this.compatibleStates.add(state);
        return this;
    }

    final GeneralGenerationPhaseState bake() {
        if (this.isBaked) {
            throw new IllegalStateException("This state is already baked! " + this.id);
        }
        this.compatibleStates = ImmutableSet.copyOf(this.compatibleStates);
        this.isBaked = true;
        return this;
    }

    @Override
    public boolean requiresPost() {
        return false;
    }

    @Override
    public final boolean isNotReEntrant() {
        return false;
    }

    @Override
    public boolean ignoresBlockEvent() {
        return true;
    }

    @Override
    public boolean ignoresBlockUpdateTick(G context) {
        return true;
    }

    @Override
    public boolean isWorldGeneration() {
        return true;
    }

    @Override
    public boolean includesDecays() {
        return true;
    }

    @Override
    public boolean allowsEventListener() {
        return false;
    }

    @Override
    public void appendNotifierPreBlockTick(ServerWorld mixinWorld, BlockPos pos, G context, LocationBasedTickContext<@NonNull ?> phaseContext) {
    }

    @Override
    public boolean doesBlockEventTracking(G context) {
        return false;
    }

    @Override
    public void unwind(G context) {
    }

    @Override
    public boolean tracksCreatorsAndNotifiers() {
        return false;
    }

    @Override
    public boolean shouldProvideModifiers(G phaseContext) {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneralGenerationPhaseState that = (GeneralGenerationPhaseState)o;
        return Objects.equal((Object)this.id, (Object)that.id);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public String toString() {
        return this.desc;
    }
}

