/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.inventory;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CClickWindowPacket;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.container.ClickContainerEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.inventory.container.TrackedContainerBridge;
import org.spongepowered.common.bridge.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.event.tracking.phase.packet.PacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.InventoryPacketContext;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.util.ContainerUtil;
import org.spongepowered.common.item.util.ItemStackUtil;

public class BasicInventoryPacketState
extends PacketState<InventoryPacketContext> {
    final int stateId;
    final int stateMask;
    private static Set<Class<?>> containersFailedCapture = new ReferenceOpenHashSet();

    public BasicInventoryPacketState() {
        this(0, 0);
    }

    public BasicInventoryPacketState(int stateId) {
        this(stateId, 262143);
    }

    public BasicInventoryPacketState(int stateId, int stateMask) {
        this.stateId = stateId & stateMask;
        this.stateMask = stateMask;
    }

    @Nullable
    public ClickContainerEvent createInventoryEvent(ServerPlayerEntity playerMP, Container openContainer, Transaction<ItemStackSnapshot> transaction, List<SlotTransaction> slotTransactions, List<Entity> capturedEntities, int usedButton, @Nullable Slot slot) {
        return null;
    }

    protected boolean shouldFire() {
        return ShouldFire.CLICK_CONTAINER_EVENT;
    }

    @Override
    public boolean matches(int packetState) {
        return this.stateMask != 0 && (packetState & this.stateMask & this.stateId) == (packetState & this.stateMask);
    }

    @Override
    public void populateContext(ServerPlayerEntity playerMP, IPacket<?> packet, InventoryPacketContext context) {
        ((TrackedInventoryBridge)playerMP.openContainer).bridge$setCaptureInventory(true);
    }

    @Override
    public boolean shouldCaptureEntity() {
        return true;
    }

    @Override
    public InventoryPacketContext createNewContext(PhaseTracker tracker) {
        return (InventoryPacketContext)((InventoryPacketContext)new InventoryPacketContext(this, tracker).addCaptures()).addEntityDropCaptures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unwind(InventoryPacketContext context) {
        ServerPlayerEntity player = context.getPacketPlayer();
        TrackedInventoryBridge trackedInventory = (TrackedInventoryBridge)player.openContainer;
        if (!trackedInventory.bridge$capturingInventory() && !context.hasCaptures()) {
            trackedInventory.bridge$getCapturedSlotTransactions().clear();
            return;
        }
        CClickWindowPacket packetIn = (CClickWindowPacket)context.getPacket();
        Transaction<ItemStackSnapshot> cursorTransaction = this.getCursorTransaction(context, player);
        net.minecraft.inventory.container.Container openContainer = player.openContainer;
        List<SlotTransaction> slotTransactions = trackedInventory.bridge$getCapturedSlotTransactions();
        int usedButton = packetIn.getUsedButton();
        ArrayList<Entity> capturedItems = new ArrayList<Entity>();
        if (!this.shouldFire()) {
            if (ShouldFire.SPAWN_ENTITY_EVENT && !capturedItems.isEmpty()) {
                for (Entity entity : capturedItems) {
                    if (entity instanceof CreatorTrackedBridge) {
                        ((CreatorTrackedBridge)((Object)entity)).tracked$setCreatorReference(((ServerPlayer)player).getUser());
                        continue;
                    }
                    entity.offer(Keys.CREATOR, player.getUniqueID());
                }
                Throwable throwable = null;
                try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                    PhaseTracker.getCauseStackManager().pushCause(openContainer);
                    PhaseTracker.getCauseStackManager().pushCause(player);
                    frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PLACEMENT);
                    SpongeCommonEventFactory.callSpawnEntity(capturedItems, context);
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
            }
            slotTransactions.clear();
            trackedInventory.bridge$setCaptureInventory(false);
            return;
        }
        Slot slot = null;
        if (packetIn.getSlotId() >= 0) {
            slot = ((InventoryAdapter)((Object)trackedInventory)).inventoryAdapter$getSlot(packetIn.getSlotId()).orElse(null);
        }
        try (CauseStackManager.StackFrame stackFrame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            ClickContainerEvent inventoryEvent;
            PhaseTracker.getCauseStackManager().pushCause(openContainer);
            PhaseTracker.getCauseStackManager().pushCause(player);
            if (slotTransactions.isEmpty() && packetIn.getSlotId() >= 0 && capturedItems.isEmpty()) {
                if (player.openContainer.windowId != packetIn.getWindowId()) {
                    return;
                }
                if (!((TrackedContainerBridge)((Object)trackedInventory)).bridge$capturePossible()) {
                    if (containersFailedCapture.add(trackedInventory.getClass())) {
                        SpongeCommon.getLogger().warn("Changes in modded Container were not captured. Inventory events will not fire for this. Container: " + openContainer.getClass());
                    }
                    return;
                }
                if (slot != null) {
                    ItemStackSnapshot item = slot.peek().createSnapshot();
                    slotTransactions.add(new SlotTransaction(slot, item, item));
                }
            }
            if ((inventoryEvent = this.createInventoryEvent(player, ContainerUtil.fromNative(openContainer), cursorTransaction, new ArrayList<SlotTransaction>(slotTransactions), capturedItems, usedButton, slot)) != null) {
                if (!(inventoryEvent instanceof ClickContainerEvent.Drag)) {
                    PacketPhaseUtil.validateCapturedTransactions(packetIn.getSlotId(), openContainer, inventoryEvent.getTransactions());
                }
                SpongeCommon.postEvent(inventoryEvent);
                if (inventoryEvent.isCancelled() || !inventoryEvent.getCursorTransaction().isValid()) {
                    PacketPhaseUtil.handleCustomCursor((PlayerEntity)player, inventoryEvent.getCursorTransaction().getOriginal());
                } else if (inventoryEvent.getCursorTransaction().getCustom().isPresent()) {
                    PacketPhaseUtil.handleCustomCursor((PlayerEntity)player, inventoryEvent.getCursorTransaction().getFinal());
                }
                PacketPhaseUtil.handleSlotRestore((PlayerEntity)player, openContainer, inventoryEvent.getTransactions(), inventoryEvent.isCancelled());
                if (!inventoryEvent.isCancelled()) {
                    if (inventoryEvent instanceof SpawnEntityEvent) {
                        BasicInventoryPacketState.processSpawnedEntities(player, (SpawnEntityEvent)((Object)inventoryEvent));
                    } else if (!capturedItems.isEmpty()) {
                        stackFrame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PLACEMENT);
                        SpongeCommonEventFactory.callSpawnEntity(capturedItems, context);
                    }
                } else if (inventoryEvent instanceof ClickContainerEvent.Drop) {
                    capturedItems.clear();
                }
            }
        }
        finally {
            slotTransactions.clear();
            trackedInventory.bridge$setCaptureInventory(false);
        }
    }

    public Transaction<ItemStackSnapshot> getCursorTransaction(InventoryPacketContext context, ServerPlayerEntity player) {
        ItemStackSnapshot lastCursor = context.getCursor();
        ItemStackSnapshot newCursor = ItemStackUtil.snapshotOf(player.inventory.getItemStack());
        return new Transaction<ItemStackSnapshot>(lastCursor, newCursor);
    }
}

