/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.inventory;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CHeldItemChangePacket;
import net.minecraft.network.play.server.SHeldItemChangePacket;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.item.inventory.ChangeInventoryEvent;
import org.spongepowered.api.event.item.inventory.container.ClickContainerEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.event.tracking.phase.packet.inventory.BasicInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.InventoryPacketContext;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.util.ItemStackUtil;

public final class SwitchHotbarScrollState
extends BasicInventoryPacketState {
    @Override
    public void populateContext(ServerPlayerEntity playerMP, IPacket<?> packet, InventoryPacketContext context) {
        super.populateContext(playerMP, packet, context);
        context.setOldHighlightedSlot(playerMP.inventory.currentItem);
    }

    @Override
    public ClickContainerEvent createInventoryEvent(ServerPlayerEntity playerMP, Container openContainer, Transaction<ItemStackSnapshot> transaction, List<SlotTransaction> slotTransactions, List<Entity> capturedEntities, int usedButton, @Nullable Slot slot) {
        return SpongeEventFactory.createClickContainerEventNumberPress(PhaseTracker.getCauseStackManager().getCurrentCause(), openContainer, transaction, Optional.ofNullable(slot), slotTransactions, usedButton);
    }

    @Override
    public void unwind(InventoryPacketContext context) {
        ServerPlayerEntity player = context.getPacketPlayer();
        CHeldItemChangePacket itemChange = (CHeldItemChangePacket)context.getPacket();
        int previousSlot = context.getOldHighlightedSlotId();
        PlayerContainer inventoryContainer = player.container;
        PlayerInventory inventory = player.inventory;
        int preHotbarSize = inventory.mainInventory.size() - PlayerInventory.getHotbarSize() + inventory.armorInventory.size() + 4 + 1;
        net.minecraft.inventory.container.Slot sourceSlot = inventoryContainer.getSlot(previousSlot + preHotbarSize);
        net.minecraft.inventory.container.Slot targetSlot = inventoryContainer.getSlot(itemChange.getSlotId() + preHotbarSize);
        ItemStackSnapshot sourceSnapshot = ItemStackUtil.snapshotOf(sourceSlot.getStack());
        ItemStackSnapshot targetSnapshot = ItemStackUtil.snapshotOf(targetSlot.getStack());
        Slot slotPrev = ((InventoryAdapter)inventoryContainer).inventoryAdapter$getSlot(previousSlot + preHotbarSize).get();
        SlotTransaction sourceTransaction = new SlotTransaction(slotPrev, sourceSnapshot, sourceSnapshot);
        Slot slotNew = ((InventoryAdapter)inventoryContainer).inventoryAdapter$getSlot(itemChange.getSlotId() + preHotbarSize).get();
        SlotTransaction targetTransaction = new SlotTransaction(slotNew, targetSnapshot, targetSnapshot);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(player);
            ImmutableList transactions = new ImmutableList.Builder().add((Object)sourceTransaction).add((Object)targetTransaction).build();
            ChangeInventoryEvent.Held changeInventoryEventHeld = SpongeEventFactory.createChangeInventoryEventHeld(frame.getCurrentCause(), slotNew, (Inventory)inventoryContainer, slotPrev, (List<SlotTransaction>)transactions);
            net.minecraft.inventory.container.Container openContainer = player.openContainer;
            SpongeCommon.postEvent(changeInventoryEventHeld);
            if (changeInventoryEventHeld.isCancelled() || PacketPhaseUtil.allTransactionsInvalid(changeInventoryEventHeld.getTransactions())) {
                player.connection.sendPacket((IPacket)new SHeldItemChangePacket(previousSlot));
                inventory.currentItem = previousSlot;
            } else {
                PacketPhaseUtil.handleSlotRestore((PlayerEntity)player, openContainer, changeInventoryEventHeld.getTransactions(), false);
                inventory.currentItem = itemChange.getSlotId();
                player.markPlayerActive();
            }
            ((TrackedInventoryBridge)openContainer).bridge$setCaptureInventory(false);
        }
    }
}

