/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.player;

import java.util.function.BiConsumer;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CPlayerTryUseItemOnBlockPacket;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.bridge.block.TrackerBlockEventDataBridge;
import org.spongepowered.common.bridge.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.SpongeLocatableBlockBuilder;

public final class PlaceBlockPacketState
extends BasicPacketState {
    private BiConsumer<CauseStackManager.StackFrame, BasicPacketContext> BASIC_PACKET_MODIFIER = IPhaseState.DEFAULT_OWNER_NOTIFIER.andThen((frame, ctx) -> {
        frame.addContext(EventContextKeys.PLAYER_PLACE, ctx.getSpongePlayer().getWorld());
        frame.addContext(EventContextKeys.USED_HAND, ctx.getHandUsed());
        frame.addContext(EventContextKeys.USED_ITEM, ctx.getItemUsedSnapshot());
        frame.pushCause(ctx.getSpongePlayer());
    });

    @Override
    public BiConsumer<CauseStackManager.StackFrame, BasicPacketContext> getFrameModifier() {
        return this.BASIC_PACKET_MODIFIER;
    }

    @Override
    public boolean isInteraction() {
        return true;
    }

    @Override
    public void populateContext(ServerPlayerEntity playerMP, IPacket<?> packet, BasicPacketContext context) {
        CPlayerTryUseItemOnBlockPacket placeBlock = (CPlayerTryUseItemOnBlockPacket)packet;
        net.minecraft.item.ItemStack itemUsed = playerMP.getHeldItem(placeBlock.getHand());
        ItemStack itemstack = ItemStackUtil.cloneDefensive(itemUsed);
        context.itemUsed(itemstack);
        HandType handType = (HandType)placeBlock.getHand();
        context.handUsed(handType);
    }

    @Override
    public void postBlockTransactionApplication(BlockChange blockChange, Transaction<? extends BlockSnapshot> transaction, BasicPacketContext context) {
        TrackingUtil.associateTrackerToTarget(blockChange, transaction, ((ServerPlayer)context.getPacketPlayer()).getUser());
    }

    @Override
    public void appendNotifierToBlockEvent(BasicPacketContext context, TrackedWorldBridge mixinWorldServer, BlockPos pos, TrackerBlockEventDataBridge blockEvent) {
        Player player = PhaseTracker.getCauseStackManager().getCurrentCause().first(Player.class).get();
        BlockState state = ((ServerWorld)((Object)mixinWorldServer)).getBlock(pos.getX(), pos.getY(), pos.getZ());
        LocatableBlock locatable = new SpongeLocatableBlockBuilder().world((ServerWorld)((Object)mixinWorldServer)).position(pos.getX(), pos.getY(), pos.getZ()).state(state).build();
        blockEvent.bridge$setTickingLocatable(locatable);
        blockEvent.bridge$setSourceUser(((ServerPlayer)player).getUser());
    }

    @Override
    public void unwind(BasicPacketContext context) {
        ServerPlayerEntity player = context.getPacketPlayer();
        ItemStack itemStack = context.getItemUsed();
        ItemStackSnapshot snapshot = context.getItemUsedSnapshot();
        Hand hand = (Hand)context.getHandUsed();
        net.minecraft.item.ItemStack replaced = player.getHeldItem(hand);
        player.setHeldItem(hand, ItemStackUtil.toNative(itemStack.copy()));
        if (!TrackingUtil.processBlockCaptures(context) && !snapshot.isEmpty()) {
            PacketPhaseUtil.handlePlayerSlotRestore(player, ItemStackUtil.toNative(itemStack), hand);
        } else {
            player.setHeldItem(hand, replaced);
        }
        TrackedInventoryBridge trackedInventory = (TrackedInventoryBridge)player.openContainer;
        trackedInventory.bridge$setCaptureInventory(false);
        trackedInventory.bridge$getCapturedSlotTransactions().clear();
    }

    @Override
    public SpawnType getEntitySpawnType(BasicPacketContext context) {
        if (context.getItemUsed().getType() instanceof SpawnEggItem) {
            return SpawnTypes.SPAWN_EGG.get();
        }
        return SpawnTypes.PLACEMENT.get();
    }
}

