/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.IFluidState;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.World;
import org.spongepowered.common.bridge.TrackableBridge;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickContext;

public class FluidTickContext
extends LocationBasedTickContext<FluidTickContext> {
    IFluidState tickingBlock;
    boolean providesModifier;
    World<?> world;

    protected FluidTickContext(IPhaseState<FluidTickContext> phaseState, PhaseTracker tracker) {
        super(phaseState, tracker);
    }

    @Override
    public FluidTickContext source(Object owner) {
        super.source(owner);
        if (owner instanceof LocatableBlock) {
            LocatableBlock locatableBlock = (LocatableBlock)owner;
            Block block = ((BlockState)locatableBlock.getBlockState()).getBlock();
            this.providesModifier = !(block instanceof FlowingFluidBlock);
            this.world = locatableBlock.getWorld();
            if (block instanceof TrackableBridge) {
                TrackableBridge trackable = (TrackableBridge)block;
                ((FluidTickContext)((FluidTickContext)((FluidTickContext)this.setBlockEvents(trackable.bridge$allowsBlockEventCreation())).setBulkBlockCaptures(trackable.bridge$allowsBlockBulkCaptures())).setEntitySpawnEvents(trackable.bridge$allowsEntityEventCreation())).setBulkEntityCaptures(trackable.bridge$allowsEntityBulkCaptures());
            }
        }
        return this;
    }

    public FluidTickContext fluid(IFluidState fluidState) {
        this.tickingBlock = fluidState;
        return this;
    }

    @Override
    protected void reset() {
        super.reset();
        this.tickingBlock = null;
        this.providesModifier = true;
        this.world = null;
    }
}

