/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.PlayerTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;

class PlayerTickPhaseState
extends TickPhaseState<PlayerTickContext> {
    PlayerTickPhaseState() {
    }

    @Override
    protected PlayerTickContext createNewContext(PhaseTracker tracker) {
        return (PlayerTickContext)((PlayerTickContext)new PlayerTickContext(tracker).addCaptures()).addEntityDropCaptures();
    }

    @Override
    public void unwind(PlayerTickContext context) {
        Player player = context.getSource(Player.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on a Player!", context));
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(player);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            TrackingUtil.processBlockCaptures(context);
        }
    }

    @Override
    public void appendContextPreExplosion(ExplosionContext explosionContext, PlayerTickContext context) {
        Player player = context.getSource(Player.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be processing over a ticking TileEntity!", context));
        explosionContext.creator(((ServerPlayer)player).getUser());
        explosionContext.notifier(((ServerPlayer)player).getUser());
        explosionContext.source(player);
    }

    @Override
    public boolean doesDenyChunkRequests(PlayerTickContext context) {
        return false;
    }
}

