/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.fluid;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.state.IProperty;
import net.minecraft.util.registry.Registry;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.common.fluid.SpongeFluidStateBuilder;

public final class FluidStateSerializer {
    private static final Function<Map.Entry<IProperty<?>, Comparable<?>>, String> MAP_ENTRY_TO_STRING = p_apply_1_ -> {
        if (p_apply_1_ == null) {
            return "<NULL>";
        }
        IProperty iproperty = (IProperty)p_apply_1_.getKey();
        return iproperty.getName() + "=" + iproperty.getName((Comparable)p_apply_1_.getValue());
    };

    public static String serialize(FluidState state) {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append(Registry.FLUID.getKey((Object)((Fluid)state.getType())).toString());
        if (!((BlockState)state).getValues().isEmpty()) {
            stringbuilder.append('[');
            stringbuilder.append(((IFluidState)state).getValues().entrySet().stream().map(MAP_ENTRY_TO_STRING).collect(Collectors.joining(",")));
            stringbuilder.append(']');
        }
        return stringbuilder.toString();
    }

    public static Optional<FluidState> deserialize(String string) {
        String state = Objects.requireNonNull(string, "Id cannot be null!").toLowerCase(Locale.ENGLISH);
        try {
            return Optional.of(new SpongeFluidStateBuilder().fromString(state).build());
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }
}

