/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.fluid;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.IFluidState;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.fluid.FluidType;
import org.spongepowered.api.fluid.FluidTypes;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.DataUtil;

public final class SpongeFluidStateBuilder
implements FluidState.Builder {
    private org.spongepowered.api.fluid.FluidState state = (org.spongepowered.api.fluid.FluidState)FluidTypes.EMPTY.get().getDefaultState();

    @Override
    public  @NonNull FluidState.Builder fluid(@NonNull FluidType fluidType) {
        this.state = (org.spongepowered.api.fluid.FluidState)Objects.requireNonNull(fluidType).getDefaultState();
        return this;
    }

    @Override
    public  @NonNull FluidState.Builder fromString(@NonNull String id) {
        this.state = this.parseString(id);
        return this;
    }

    @Override
    public <V>  @NonNull FluidState.Builder add(@NonNull Key<@NonNull ? extends Value<V>> key, @NonNull V value) {
        Objects.requireNonNull(this.state, "The fluid type must be set first");
        Objects.requireNonNull(key, "The key must not be null");
        Objects.requireNonNull(key, "The value must not be null");
        this.state = this.state.with(key, value).orElse(this.state);
        return this;
    }

    @Override
    public  @NonNull FluidState.Builder from(@NonNull org.spongepowered.api.fluid.FluidState holder) {
        this.state = holder;
        return this;
    }

    @Override
    public @NonNull org.spongepowered.api.fluid.FluidState build() {
        Objects.requireNonNull(this.state, "There must be a FluidType specified.");
        return this.state;
    }

    @Override
    public  @NonNull FluidState.Builder reset() {
        this.state = null;
        return this;
    }

    @Override
    public @NonNull Optional<org.spongepowered.api.fluid.FluidState> build(@NonNull DataView container) throws InvalidDataException {
        if (!container.contains(Constants.Fluids.FLUID_STATE)) {
            return Optional.empty();
        }
        DataUtil.checkDataExists(container, Constants.Fluids.FLUID_STATE);
        try {
            return container.getString(Constants.Fluids.FLUID_STATE).map(this::parseString);
        }
        catch (Exception e) {
            throw new InvalidDataException("Could not retrieve a blockstate!", e);
        }
    }

    private org.spongepowered.api.fluid.FluidState parseString(String string) {
        StringReader reader = new StringReader(string);
        try {
            Fluid fluid = this.readFluid(reader);
            Object state = reader.canRead() && reader.peek() == '[' ? this.readProperties(reader, fluid) : fluid.getDefaultState();
            return (org.spongepowered.api.fluid.FluidState)state;
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("The string " + string + " doe not parse into a valid FluidState", e);
        }
    }

    private Fluid readFluid(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        ResourceLocation fluidKey = ResourceLocation.read((StringReader)reader);
        return (Fluid)Registry.FLUID.getValue(fluidKey).orElseThrow(() -> {
            reader.setCursor(cursor);
            return BlockStateParser.STATE_BAD_ID.createWithContext((ImmutableStringReader)reader, (Object)fluidKey.toString());
        });
    }

    private FluidState readProperties(StringReader reader, Fluid fluid) throws CommandSyntaxException {
        reader.skip();
        reader.skipWhitespace();
        IFluidState state = fluid.getDefaultState();
        StateContainer stateContainer = fluid.getStateContainer();
        while (reader.canRead() && reader.peek() != ']') {
            reader.skipWhitespace();
            int cursor = reader.getCursor();
            String propertyKey = reader.readString();
            IProperty property = stateContainer.getProperty(propertyKey);
            if (property == null) {
                reader.setCursor(cursor);
                throw BlockStateParser.STATE_UNKNOWN_PROPERTY.createWithContext((ImmutableStringReader)reader, (Object)fluid.toString(), (Object)propertyKey);
            }
            reader.skipWhitespace();
            if (reader.canRead() && reader.peek() == '=') {
                reader.skip();
                reader.skipWhitespace();
                int cursor1 = reader.getCursor();
                state = this.parseValue(state, reader, property, cursor1);
                reader.skipWhitespace();
                if (!reader.canRead()) continue;
                if (reader.peek() == ',') {
                    reader.skip();
                    continue;
                }
                if (reader.peek() == ']') break;
                throw BlockStateParser.STATE_UNCLOSED.createWithContext((ImmutableStringReader)reader);
            }
            throw BlockStateParser.STATE_NO_VALUE.createWithContext((ImmutableStringReader)reader, (Object)fluid.toString(), (Object)propertyKey);
        }
        if (!reader.canRead()) {
            throw BlockStateParser.STATE_UNCLOSED.createWithContext((ImmutableStringReader)reader);
        }
        reader.skip();
        return (FluidState)state;
    }

    private <T extends Comparable<T>> IFluidState parseValue(IFluidState state, StringReader reader, IProperty<T> property, int cursor) throws CommandSyntaxException {
        Optional propertyValue = property.parseValue(reader.readString());
        if (propertyValue.isPresent()) {
            return (IFluidState)state.with(property, (Comparable)propertyValue.get());
        }
        reader.setCursor(cursor);
        throw BlockStateParser.STATE_INVALID_PROPERTY_VALUE.createWithContext((ImmutableStringReader)reader, (Object)state.getFluid().toString(), (Object)property.getName(), (Object)cursor);
    }
}

