/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.hooks;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import javax.management.MBeanServer;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.DimensionType;
import org.apache.logging.log4j.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.bridge.world.storage.WorldInfoBridge;
import org.spongepowered.common.config.inheritable.BaseConfig;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.LoggingCategory;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.math.vector.Vector3i;

public final class SpongeHooks {
    private static Object2LongMap<CollisionWarning> recentWarnings = new Object2LongOpenHashMap();

    public static void logInfo(String msg, Object ... args) {
        SpongeCommon.getLogger().info(MessageFormat.format(msg, args));
    }

    public static void logWarning(String msg, Object ... args) {
        SpongeCommon.getLogger().warn(MessageFormat.format(msg, args));
    }

    public static void logSevere(String msg, Object ... args) {
        SpongeCommon.getLogger().fatal(MessageFormat.format(msg, args));
    }

    public static void logStack(InheritableConfigHandle<? extends BaseConfig> config) {
        if (((BaseConfig)config.get()).getLogging().logWithStackTraces()) {
            Throwable ex = new Throwable();
            ex.fillInStackTrace();
            SpongeCommon.getLogger().catching(Level.INFO, ex);
        }
    }

    public static void logEntityDeath(@Nullable Entity entity) {
        if (entity == null || entity.getEntityWorld().isRemote()) {
            return;
        }
        InheritableConfigHandle<WorldConfig> configAdapter = ((WorldInfoBridge)entity.getEntityWorld().getWorldInfo()).bridge$getConfigAdapter();
        if (((WorldConfig)configAdapter.get()).getLogging().entityDeathLogging()) {
            SpongeHooks.logInfo("Dimension: {0} setDead(): {1}", entity.getEntityWorld().getDimension().getType(), entity);
            SpongeHooks.logStack(configAdapter);
        }
    }

    public static void logEntityDespawn(@Nullable Entity entity, String reason) {
        if (entity == null || entity.getEntityWorld().isRemote()) {
            return;
        }
        InheritableConfigHandle<WorldConfig> configAdapter = ((WorldInfoBridge)entity.getEntityWorld().getWorldInfo()).bridge$getConfigAdapter();
        if (((WorldConfig)configAdapter.get()).getLogging().entityDespawnLogging()) {
            SpongeHooks.logInfo("Dimension: {0} Despawning ({1}): {2}", entity.getEntityWorld().getDimension().getType(), reason, entity);
            SpongeHooks.logStack(configAdapter);
        }
    }

    public static void logEntitySpawn(@Nullable Entity entity) {
        if (entity == null) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        ITextComponent spawnName = entity.getName();
        InheritableConfigHandle<WorldConfig> configAdapter = ((WorldInfoBridge)entity.getEntityWorld().getWorldInfo()).bridge$getConfigAdapter();
        if (((WorldConfig)configAdapter.get()).getLogging().entitySpawnLogging()) {
            SpongeHooks.logInfo("SPAWNED " + spawnName.getUnformattedComponentText() + " [Dimension: {1}]", entity.getEntityWorld().dimension.getType());
            SpongeHooks.logStack(configAdapter);
        }
    }

    public static void logBlockTrack(World world, Block block, BlockPos pos, User user, boolean allowed) {
        if (world.isRemote()) {
            return;
        }
        InheritableConfigHandle<WorldConfig> configAdapter = ((WorldInfoBridge)world.getWorldInfo()).bridge$getConfigAdapter();
        if (((WorldConfig)configAdapter.get()).getLogging().blockTrackLogging() && allowed) {
            SpongeHooks.logInfo("Tracking Block [RootCause: {0}][Dimension: {1}][Block: {2}][Pos: {3}]", user.getName(), world.getDimension().getType(), ((BlockType)block).getKey(), pos);
            SpongeHooks.logStack(configAdapter);
        } else if (((WorldConfig)configAdapter.get()).getLogging().blockTrackLogging() && !allowed) {
            SpongeHooks.logInfo("Blacklisted! Unable to track Block [RootCause: {0}][Dimension: {1}][Block: {2}][Pos: {3}]", user.getName(), world.getDimension().getType(), ((BlockType)block).getKey(), pos.getX() + ", " + pos.getY() + ", " + pos.getZ());
        }
    }

    public static void logBlockAction(World world, @Nullable BlockChange type, Transaction<BlockSnapshot> transaction) {
        if (world.isRemote()) {
            return;
        }
        InheritableConfigHandle<WorldConfig> configAdapter = ((WorldInfoBridge)world.getWorldInfo()).bridge$getConfigAdapter();
        LoggingCategory logging = ((WorldConfig)configAdapter.get()).getLogging();
        if (type != null && type.allowsLogging(logging)) {
            SpongeHooks.logInfo("Block " + type.name() + " [Dimension: {0}][OriginalState: {1}][NewState: {2}]", world.getDimension().getType(), transaction.getOriginal().getState(), transaction.getFinal().getState());
            SpongeHooks.logStack(configAdapter);
        }
    }

    public static void logChunkQueueLoad(World world, Vector3i chunkPos) {
        if (world.isRemote()) {
            return;
        }
        InheritableConfigHandle<WorldConfig> configAdapter = ((WorldInfoBridge)world.getWorldInfo()).bridge$getConfigAdapter();
        if (((WorldConfig)configAdapter.get()).getLogging().chunkLoadLogging()) {
            SpongeHooks.logInfo("Queue Chunk At [{0}] ({1}, {2})", world.getDimension().getType(), chunkPos.getX(), chunkPos.getZ());
            SpongeHooks.logStack(configAdapter);
        }
    }

    public static void logChunkLoad(World world, Vector3i chunkPos) {
        if (world.isRemote()) {
            return;
        }
        InheritableConfigHandle<WorldConfig> configAdapter = ((WorldInfoBridge)world.getWorldInfo()).bridge$getConfigAdapter();
        if (((WorldConfig)configAdapter.get()).getLogging().chunkLoadLogging()) {
            SpongeHooks.logInfo("Load Chunk in Dimension [{0}] ({1}, {2})", world.getDimension().getType(), chunkPos.getX(), chunkPos.getZ());
            SpongeHooks.logStack(configAdapter);
        }
    }

    public static void logChunkUnload(World world, Vector3i chunkPos) {
        if (world.isRemote()) {
            return;
        }
        InheritableConfigHandle<WorldConfig> configAdapter = ((WorldInfoBridge)world.getWorldInfo()).bridge$getConfigAdapter();
        if (((WorldConfig)configAdapter.get()).getLogging().chunkUnloadLogging()) {
            SpongeHooks.logInfo("Unload Chunk in Dimension [{0}] ({1}, {2})", world.getDimension().getType(), chunkPos.getX(), chunkPos.getZ());
            SpongeHooks.logStack(configAdapter);
        }
    }

    public static void logChunkGCQueueUnload(World world, Chunk chunk) {
        if (world.isRemote()) {
            return;
        }
        InheritableConfigHandle<WorldConfig> configAdapter = ((WorldInfoBridge)world.getWorldInfo()).bridge$getConfigAdapter();
        if (((WorldConfig)configAdapter.get()).getLogging().chunkGCQueueUnloadLogging()) {
            SpongeHooks.logInfo("Chunk GC Queued Chunk in Dimension '{0}' ({2}, {3} for unload)", world.getDimension().getType(), chunk.getPos().x, chunk.getPos().z);
            SpongeHooks.logStack(configAdapter);
        }
    }

    public static void logExploitItemNameOverflow(PlayerEntity player, int length) {
        if (player.getEntityWorld().isRemote()) {
            return;
        }
        InheritableConfigHandle<WorldConfig> configAdapter = ((WorldInfoBridge)player.getEntityWorld().getWorldInfo()).bridge$getConfigAdapter();
        if (((WorldConfig)configAdapter.get()).getLogging().logExploitItemStackNameOverflow) {
            SpongeHooks.logInfo("[EXPLOIT] Player '{0}' attempted to send a creative itemstack update with a display name length of '{1}' (Max allowed length is 32767). This has been blocked to avoid server overflow.", player.getName(), length);
            SpongeHooks.logStack(configAdapter);
        }
    }

    public static boolean checkBoundingBoxSize(@Nullable Entity entity, AxisAlignedBB aabb) {
        if (entity == null || entity.getEntityWorld().isRemote()) {
            return false;
        }
        InheritableConfigHandle<WorldConfig> configAdapter = ((WorldInfoBridge)entity.getEntityWorld().getWorldInfo()).bridge$getConfigAdapter();
        if (!(entity instanceof LivingEntity) || entity instanceof PlayerEntity || entity instanceof EnderDragonPartEntity) {
            return false;
        }
        int maxBoundingBoxSize = ((WorldConfig)configAdapter.get()).getEntity().getMaxBoundingBoxSize();
        if (maxBoundingBoxSize <= 0) {
            return false;
        }
        int x = MathHelper.floor((double)aabb.minX);
        int x1 = MathHelper.floor((double)(aabb.maxX + 1.0));
        int y = MathHelper.floor((double)aabb.minY);
        int y1 = MathHelper.floor((double)(aabb.maxY + 1.0));
        int z = MathHelper.floor((double)aabb.minZ);
        int z1 = MathHelper.floor((double)(aabb.maxZ + 1.0));
        int size = Math.abs(x1 - x) * Math.abs(y1 - y) * Math.abs(z1 - z);
        if (size > maxBoundingBoxSize) {
            SpongeHooks.logWarning("Entity being removed for bounding box restrictions", new Object[0]);
            SpongeHooks.logWarning("BB Size: {0} > {1} avg edge: {2}", size, maxBoundingBoxSize, aabb.getAverageEdgeLength());
            SpongeHooks.logWarning("Motion: ({0}, {1}, {2})", entity.getMotion().x, entity.getMotion().y, entity.getMotion().z);
            SpongeHooks.logWarning("Calculated bounding box: {0}", aabb);
            SpongeHooks.logWarning("Entity bounding box: {0}", entity.getCollisionBoundingBox());
            SpongeHooks.logWarning("Entity: {0}", entity);
            CompoundNBT compound = new CompoundNBT();
            entity.writeWithoutTypeId(compound);
            SpongeHooks.logWarning("Entity NBT: {0}", compound);
            SpongeHooks.logStack(configAdapter);
            entity.remove();
            return true;
        }
        return false;
    }

    public static boolean checkEntitySpeed(@Nullable Entity entity, double x, double y, double z) {
        double distance;
        if (entity == null || entity.getEntityWorld().isRemote()) {
            return false;
        }
        InheritableConfigHandle<WorldConfig> configAdapter = ((WorldInfoBridge)entity.world.getWorldInfo()).bridge$getConfigAdapter();
        int maxSpeed = ((WorldConfig)configAdapter.get()).getEntity().getMaxSpeed();
        if (maxSpeed > 0 && (distance = x * x + z * z) > (double)maxSpeed && !entity.isPassenger()) {
            if (((WorldConfig)configAdapter.get()).getLogging().logEntitySpeedRemoval()) {
                SpongeHooks.logInfo("Speed violation: {0} was over {1} - Removing Entity: {2}", distance, maxSpeed, entity);
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    SpongeHooks.logInfo("Entity Motion: ({0}, {1}, {2}) Move Strafing: {3} Move Forward: {4}", entity.getMotion().x, entity.getMotion().y, entity.getMotion().z, Float.valueOf(livingEntity.moveStrafing), Float.valueOf(livingEntity.moveForward));
                }
                if (((WorldConfig)configAdapter.get()).getLogging().logWithStackTraces()) {
                    SpongeHooks.logInfo("Move offset: ({0}, {1}, {2})", x, y, z);
                    SpongeHooks.logInfo("Motion: ({0}, {1}, {2})", entity.getMotion().x, entity.getMotion().y, entity.getMotion().z);
                    SpongeHooks.logInfo("Entity: {0}", entity);
                    CompoundNBT compound = new CompoundNBT();
                    entity.writeWithoutTypeId(compound);
                    SpongeHooks.logInfo("Entity NBT: {0}", compound);
                    SpongeHooks.logStack(configAdapter);
                }
            }
            if (entity instanceof PlayerEntity) {
                entity.setMotion(Vec3d.ZERO);
                return false;
            }
            entity.removed = true;
            return false;
        }
        return true;
    }

    public static void logEntitySize(@Nullable Entity entity, List list) {
        if (entity == null || list == null || entity.getEntityWorld().isRemote()) {
            return;
        }
        InheritableConfigHandle<WorldConfig> configAdapter = ((WorldInfoBridge)entity.getEntityWorld().getWorldInfo()).bridge$getConfigAdapter();
        if (!((WorldConfig)configAdapter.get()).getLogging().logEntityCollisionChecks()) {
            return;
        }
        int collisionWarnSize = ((WorldConfig)configAdapter.get()).getEntity().getMaxCollisionSize();
        if (collisionWarnSize > 0 && entity.getServer().getTickCounter() % 10 == 0 && list.size() >= collisionWarnSize) {
            CollisionWarning warning = new CollisionWarning(entity.getEntityWorld().getDimension().getType(), entity);
            if (recentWarnings.containsKey((Object)warning)) {
                long lastWarned = recentWarnings.get((Object)warning);
                if (entity.getServer().getServerTime() - lastWarned < 30000L) {
                    return;
                }
            }
            recentWarnings.put((Object)warning, System.currentTimeMillis());
            SpongeHooks.logWarning("Entity collision > {0, number} at: {1}", collisionWarnSize, entity);
        }
    }

    public static void dumpHeap(File file, boolean live) {
        try {
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            Class<?> clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            Object hotspotMBean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", clazz);
            Method m3 = clazz.getMethod("dumpHeap", String.class, Boolean.TYPE);
            m3.invoke(hotspotMBean, file.getPath(), live);
        }
        catch (Throwable t) {
            SpongeHooks.logSevere("Could not write heap to {0}", file);
        }
    }

    public static void enableThreadContentionMonitoring() {
        if (!SpongeConfigs.getCommon().get().getDebug().isEnableThreadContentionMonitoring()) {
            return;
        }
        ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
        mbean.setThreadContentionMonitoringEnabled(true);
    }

    private static class CollisionWarning {
        public BlockPos blockPos;
        public DimensionType dimensionType;

        public CollisionWarning(DimensionType dimensionType, Entity entity) {
            this.dimensionType = dimensionType;
            this.blockPos = new BlockPos(entity.chunkCoordX, entity.chunkCoordY, entity.chunkCoordZ);
        }

        public boolean equals(Object otherObj) {
            if (!(otherObj instanceof CollisionWarning)) {
                return false;
            }
            CollisionWarning other = (CollisionWarning)otherObj;
            return other.dimensionType == this.dimensionType && other.blockPos.equals((Object)this.blockPos);
        }

        public int hashCode() {
            return Objects.hash(this.blockPos, this.dimensionType);
        }
    }
}

