/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inject.plugin;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Scopes;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.asset.AssetId;
import org.spongepowered.common.inject.InjectionPointProvider;
import org.spongepowered.common.inject.provider.PluginAssetProvider;
import org.spongepowered.common.inject.provider.PluginConfigurationModule;
import org.spongepowered.plugin.PluginContainer;

public final class PluginModule
extends AbstractModule {
    private final PluginContainer container;
    private final Class<?> pluginClass;

    public PluginModule(PluginContainer container, Class<?> pluginClass) {
        this.container = container;
        this.pluginClass = pluginClass;
    }

    protected void configure() {
        this.bind(this.pluginClass).in(Scopes.SINGLETON);
        this.install(new InjectionPointProvider());
        this.bind(PluginContainer.class).toInstance((Object)this.container);
        this.bind(Logger.class).toInstance((Object)this.container.getLogger());
        this.bind(Asset.class).annotatedWith(AssetId.class).toProvider(PluginAssetProvider.class);
        this.install((Module)new PluginConfigurationModule());
    }
}

