/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory;

import java.util.Arrays;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.util.Direction;
import org.spongepowered.api.item.inventory.BlockCarrier;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.SingleBlockCarrier;
import org.spongepowered.api.item.inventory.query.Query;
import org.spongepowered.api.item.inventory.query.QueryTypes;
import org.spongepowered.api.item.inventory.slot.SlotMatchers;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.common.inventory.EmptyInventoryImpl;
import org.spongepowered.common.registry.provider.DirectionFacingProvider;
import org.spongepowered.common.util.MissingImplementationException;

public interface DefaultSingleBlockCarrier
extends SingleBlockCarrier {
    @Override
    default public Inventory getInventory(org.spongepowered.api.util.Direction from) {
        return DefaultSingleBlockCarrier.getInventory(from, this);
    }

    @Override
    default public CarriedInventory<? extends Carrier> getInventory() {
        if (this instanceof CarriedInventory) {
            return (CarriedInventory)((Object)this);
        }
        throw new MissingImplementationException("SingleBlockCarrier", "getInventory");
    }

    public static Inventory getInventory(org.spongepowered.api.util.Direction from, BlockCarrier thisThing) {
        if (thisThing instanceof ISidedInventory) {
            Direction facing = DirectionFacingProvider.getInstance().get(from).get();
            int[] slots = ((ISidedInventory)thisThing).getSlotsForFace(facing);
            if (slots.length == 0) {
                return new EmptyInventoryImpl(thisThing.getInventory());
            }
            Query.Builder builder = Query.builder();
            Arrays.stream(slots).mapToObj(slot -> QueryTypes.KEY_VALUE.get().of(SlotMatchers.index(slot))).forEach(xva$0 -> builder.and((Query)xva$0));
            Query query = builder.build();
            return thisThing.getInventory().query(query);
        }
        return thisThing.getInventory();
    }
}

