/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.lens.impl.comp;

import java.util.Optional;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.item.inventory.ArmorEquipable;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.equipment.EquipmentTypes;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.common.inventory.adapter.impl.comp.EquipmentInventoryAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.impl.SlotBasedLens;
import org.spongepowered.common.inventory.lens.impl.slot.SlotLensProvider;
import org.spongepowered.common.inventory.property.KeyValuePair;

public class ArmorInventoryLens
extends SlotBasedLens {
    public ArmorInventoryLens(int base, SlotLensProvider slots, boolean isContainer) {
        super(base, 4, 1, EquipmentInventoryAdapter.class, slots);
        if (isContainer) {
            this.initContainer(slots);
        } else {
            this.initInventory(slots);
        }
    }

    private void initInventory(SlotLensProvider slots) {
        int index = this.base;
        this.addSpanningChild(slots.getSlotLens(index), KeyValuePair.of(Keys.EQUIPMENT_TYPE.get(), EquipmentTypes.FEET.get()));
        this.addSpanningChild(slots.getSlotLens(index += this.stride), KeyValuePair.of(Keys.EQUIPMENT_TYPE.get(), EquipmentTypes.LEGS.get()));
        this.addSpanningChild(slots.getSlotLens(index += this.stride), KeyValuePair.of(Keys.EQUIPMENT_TYPE.get(), EquipmentTypes.CHEST.get()));
        this.addSpanningChild(slots.getSlotLens(index += this.stride), KeyValuePair.of(Keys.EQUIPMENT_TYPE.get(), EquipmentTypes.HEAD.get()));
    }

    private void initContainer(SlotLensProvider slots) {
        int index = this.base;
        this.addSpanningChild(slots.getSlotLens(index), KeyValuePair.of(Keys.EQUIPMENT_TYPE.get(), EquipmentTypes.HEAD.get()));
        this.addSpanningChild(slots.getSlotLens(index += this.stride), KeyValuePair.of(Keys.EQUIPMENT_TYPE.get(), EquipmentTypes.CHEST.get()));
        this.addSpanningChild(slots.getSlotLens(index += this.stride), KeyValuePair.of(Keys.EQUIPMENT_TYPE.get(), EquipmentTypes.LEGS.get()));
        this.addSpanningChild(slots.getSlotLens(index += this.stride), KeyValuePair.of(Keys.EQUIPMENT_TYPE.get(), EquipmentTypes.FEET.get()));
    }

    @Override
    public Inventory getAdapter(Fabric fabric, Inventory parent) {
        Optional opt;
        ArmorEquipable carrier = null;
        if (parent instanceof CarriedInventory && (opt = ((CarriedInventory)parent).getCarrier()).isPresent() && opt.get() instanceof ArmorEquipable) {
            carrier = (ArmorEquipable)opt.get();
        }
        return new EquipmentInventoryAdapter(carrier, fabric, this, parent);
    }
}

