/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.lens.impl.comp;

import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.item.inventory.Equipable;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.common.inventory.adapter.impl.comp.EquipmentInventoryAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.impl.RealLens;
import org.spongepowered.common.inventory.lens.impl.slot.EquipmentSlotLens;
import org.spongepowered.common.inventory.lens.slots.SlotLens;
import org.spongepowered.common.inventory.property.KeyValuePair;

public class EquipmentInventoryLens
extends RealLens {
    public EquipmentInventoryLens(Map<EquipmentType, SlotLens> lenses) {
        super(0, lenses.size(), EquipmentInventoryAdapter.class);
        this.init(lenses);
    }

    private void init(Map<EquipmentType, SlotLens> lenses) {
        for (Map.Entry<EquipmentType, SlotLens> entry : lenses.entrySet()) {
            this.addSpanningChild(new EquipmentSlotLens(this, entry.getValue(), entry.getKey()), KeyValuePair.of(Keys.EQUIPMENT_TYPE.get(), entry.getKey()));
        }
    }

    @Override
    public Inventory getAdapter(Fabric fabric, Inventory parent) {
        Optional opt;
        Equipable carrier = null;
        if (parent instanceof CarriedInventory && (opt = ((CarriedInventory)parent).getCarrier()).isPresent() && opt.get() instanceof Equipable) {
            carrier = (Equipable)opt.get();
        }
        return new EquipmentInventoryAdapter(carrier, fabric, this, parent);
    }
}

