/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.lens.impl.minecraft.container;

import java.util.Arrays;
import java.util.List;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.equipment.EquipmentTypes;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.comp.CraftingInventoryLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.PlayerInventoryLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.container.ContainerLens;
import org.spongepowered.common.inventory.lens.impl.slot.SlotLensProvider;
import org.spongepowered.common.inventory.property.KeyValuePair;

public class ContainerPlayerInventoryLens
extends ContainerLens {
    private static final int CRAFTING_OUTPUT = 1;
    private static final int CRAFTING_GRID = 2;

    public ContainerPlayerInventoryLens(int size, Class<? extends Inventory> adapter, SlotLensProvider slots) {
        super(size, adapter, slots, ContainerPlayerInventoryLens.lenses(size, slots));
        this.init(slots);
    }

    private static List<Lens> lenses(int size, SlotLensProvider slots) {
        int base = 1;
        CraftingInventoryLens crafting = new CraftingInventoryLens(0, base, 2, 2, slots);
        PlayerInventoryLens player = new PlayerInventoryLens(base += 4, size - base, slots);
        return Arrays.asList(crafting, player);
    }

    @Override
    protected void init(SlotLensProvider slots) {
        super.init(slots);
        this.addChild(slots.getSlotLens(this.base + 0), KeyValuePair.of(Keys.EQUIPMENT_TYPE.get(), EquipmentTypes.HEAD.get()));
        this.addChild(slots.getSlotLens(this.base + 1), KeyValuePair.of(Keys.EQUIPMENT_TYPE.get(), EquipmentTypes.CHEST.get()));
        this.addChild(slots.getSlotLens(this.base + 2), KeyValuePair.of(Keys.EQUIPMENT_TYPE.get(), EquipmentTypes.LEGS.get()));
        this.addChild(slots.getSlotLens(this.base + 3), KeyValuePair.of(Keys.EQUIPMENT_TYPE.get(), EquipmentTypes.FEET.get()));
        this.addChild(slots.getSlotLens(this.base + 4 + 36), KeyValuePair.of(Keys.EQUIPMENT_TYPE.get(), EquipmentTypes.OFF_HAND.get()));
    }
}

