/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.event.HoverEvent;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.MergeFunction;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.data.CustomDataHolderBridge;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.Constants;

public class SpongeItemStackSnapshot
implements ItemStackSnapshot {
    public static final ItemStackSnapshot EMPTY = new SpongeItemStackSnapshot(ItemStackUtil.fromNative(net.minecraft.item.ItemStack.EMPTY));
    private final ItemType itemType;
    private final int quantity;
    private final int damageValue;
    private final ImmutableList<DataManipulator.Immutable> manipulators;
    private final transient ItemStack privateStack;
    private final ImmutableSet<Key<?>> keys;
    private final ImmutableSet<Value.Immutable<?>> values;
    @Nullable
    private final CompoundNBT compound;
    @Nullable
    private UUID creatorUniqueId;

    public SpongeItemStackSnapshot(ItemStack itemStack) {
        Preconditions.checkNotNull((Object)itemStack);
        if (ItemStackUtil.toNative(itemStack) == net.minecraft.item.ItemStack.EMPTY) {
            this.itemType = itemStack.getType();
            this.quantity = 0;
            this.damageValue = 0;
            this.manipulators = ImmutableList.of();
            this.privateStack = itemStack;
            this.keys = ImmutableSet.of();
            this.values = ImmutableSet.of();
            this.compound = null;
            return;
        }
        this.itemType = itemStack.getType();
        this.quantity = itemStack.getQuantity();
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableSet.Builder keyBuilder = ImmutableSet.builder();
        ImmutableSet.Builder valueBuilder = ImmutableSet.builder();
        DataManipulator.Mutable customData = ((CustomDataHolderBridge)((Object)itemStack)).bridge$getManipulator();
        builder.add((Object)customData.asImmutable());
        keyBuilder.addAll(customData.getKeys());
        valueBuilder.addAll(customData.getValues());
        this.damageValue = ItemStackUtil.toNative(itemStack).getDamage();
        this.manipulators = builder.build();
        this.privateStack = itemStack.copy();
        this.keys = keyBuilder.build();
        this.values = valueBuilder.build();
        CompoundNBT compound = ItemStackUtil.toNative(this.privateStack).getTag();
        if (compound != null) {
            compound = compound.copy();
        }
        if (compound != null) {
            CompoundNBT spongeCompound;
            if (compound.contains("SpongeData") && (spongeCompound = compound.getCompound("SpongeData")).contains("CustomManipulators")) {
                spongeCompound.remove("CustomManipulators");
            }
            Constants.NBT.filterSpongeCustomData(compound);
            this.compound = !compound.isEmpty() ? compound : null;
        } else {
            this.compound = null;
        }
    }

    public SpongeItemStackSnapshot(ItemType itemType, int quantity, ImmutableList<DataManipulator.Immutable> manipulators, @Nullable CompoundNBT compound) {
        this.itemType = (ItemType)Preconditions.checkNotNull((Object)itemType);
        this.quantity = quantity;
        this.manipulators = (ImmutableList)Preconditions.checkNotNull(manipulators);
        this.privateStack = ItemStackUtil.fromNative(new net.minecraft.item.ItemStack((IItemProvider)((Item)this.itemType), this.quantity));
        ImmutableSet.Builder keyBuilder = ImmutableSet.builder();
        ImmutableSet.Builder valueBuilder = ImmutableSet.builder();
        for (DataManipulator.Immutable manipulator : this.manipulators) {
            this.privateStack.copyFrom(manipulator);
            keyBuilder.addAll(manipulator.getKeys());
            valueBuilder.addAll(manipulator.getValues());
        }
        this.keys = keyBuilder.build();
        this.values = valueBuilder.build();
        this.compound = compound == null ? null : compound.copy();
        this.damageValue = 0;
    }

    @Override
    public ItemType getType() {
        return this.itemType == null ? (ItemType)net.minecraft.item.ItemStack.EMPTY.getItem() : this.itemType;
    }

    @Override
    public int getQuantity() {
        return this.quantity;
    }

    @Override
    public boolean isEmpty() {
        return this.privateStack.isEmpty();
    }

    public boolean isNone() {
        throw new UnsupportedOperationException("Implement is empty");
    }

    @Override
    public ItemStack createStack() {
        net.minecraft.item.ItemStack nativeStack = ItemStackUtil.cloneDefensiveNative(ItemStackUtil.toNative(this.privateStack.copy()));
        if (this.compound != null) {
            nativeStack.setTag(this.compound.copy());
        }
        for (DataManipulator.Immutable manipulator : this.manipulators) {
            ((ItemStack)nativeStack).copyFrom(manipulator);
        }
        return ItemStackUtil.fromNative(nativeStack);
    }

    @Override
    public int getContentVersion() {
        return 2;
    }

    @Override
    public DataContainer toContainer() {
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, this.getContentVersion()).set(Constants.ItemStack.TYPE, this.itemType.getKey()).set(Constants.ItemStack.COUNT, this.quantity).set(Constants.ItemStack.DAMAGE_VALUE, this.damageValue);
        if (!this.manipulators.isEmpty()) {
            // empty if block
        }
        if (this.compound != null) {
            container.set(Constants.Sponge.UNSAFE_NBT, NbtTranslator.getInstance().translateFrom(this.compound));
        }
        return container;
    }

    @Override
    public <E> Optional<ItemStackSnapshot> transform(Key<? extends Value<E>> key, Function<E, E> function) {
        ItemStack copy = this.privateStack.copy();
        DataTransactionResult result = copy.transform(key, function);
        if (result.getType() != DataTransactionResult.Type.SUCCESS) {
            return Optional.empty();
        }
        return Optional.of(copy.createSnapshot());
    }

    @Override
    public <E> Optional<ItemStackSnapshot> with(Key<? extends Value<E>> key, E value) {
        ItemStack copy = this.privateStack.copy();
        DataTransactionResult result = copy.offer(key, value);
        if (result.getType() != DataTransactionResult.Type.SUCCESS) {
            return Optional.empty();
        }
        return Optional.of(copy.createSnapshot());
    }

    @Override
    public Optional<ItemStackSnapshot> with(Value<?> value) {
        return this.with(value.getKey(), value.get());
    }

    @Override
    public <E> Optional<E> get(Key<? extends Value<E>> key) {
        return this.privateStack.get(key);
    }

    @Override
    public <E, V extends Value<E>> Optional<V> getValue(Key<V> key) {
        return this.privateStack.getValue(key);
    }

    @Override
    public boolean supports(Key<?> key) {
        return this.privateStack.supports(key);
    }

    @Override
    public ItemStackSnapshot copy() {
        return this;
    }

    @Override
    public Set<Key<?>> getKeys() {
        return this.keys;
    }

    @Override
    public Set<Value.Immutable<?>> getValues() {
        return this.values;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("itemType", (Object)this.itemType.getKey()).add("quantity", this.quantity).toString();
    }

    public int getDamageValue() {
        return this.damageValue;
    }

    public Optional<CompoundNBT> getCompound() {
        if (this.compound != null) {
            return Optional.of(this.compound.copy());
        }
        return Optional.empty();
    }

    public Optional<UUID> getCreator() {
        return Optional.ofNullable(this.creatorUniqueId);
    }

    public void setCreator(@Nullable UUID uuid) {
        if (uuid != null) {
            this.creatorUniqueId = uuid;
        }
    }

    @Override
    public ItemStackSnapshot withRawData(DataView container) throws InvalidDataException {
        ItemStack copy = this.privateStack.copy();
        copy.setRawData(container);
        return copy.createSnapshot();
    }

    @Override
    public Optional<ItemStackSnapshot> without(Key<?> key) {
        ItemStack copy = this.privateStack.copy();
        DataTransactionResult result = copy.remove(key);
        if (result.getType() != DataTransactionResult.Type.SUCCESS) {
            return Optional.empty();
        }
        return Optional.of(copy.createSnapshot());
    }

    @Override
    public ItemStackSnapshot mergeWith(ItemStackSnapshot that, MergeFunction function) {
        ItemStack copy = this.privateStack.copy();
        copy.copyFrom(that, function);
        return copy.createSnapshot();
    }

    @Override
    public boolean validateRawData(DataView container) {
        ItemStack copy = this.privateStack.copy();
        return copy.validateRawData(container);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeItemStackSnapshot that = (SpongeItemStackSnapshot)o;
        return this.quantity == that.quantity && this.damageValue == that.damageValue && Objects.equal((Object)this.itemType, (Object)that.itemType) && Objects.equal((Object)this.compound, (Object)that.compound) && Objects.equal((Object)this.creatorUniqueId, (Object)that.creatorUniqueId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.itemType, this.quantity, this.damageValue, this.compound, this.creatorUniqueId});
    }

    public HoverEvent<HoverEvent.ShowItem> asHoverEvent(UnaryOperator<HoverEvent.ShowItem> op) {
        CompoundNBT tag = this.getCompound().orElse(null);
        return HoverEvent.showItem((HoverEvent.ShowItem)((HoverEvent.ShowItem)op.apply(HoverEvent.ShowItem.of((net.kyori.adventure.key.Key)this.getType().getKey(), (int)this.getQuantity(), (BinaryTagHolder)SpongeAdventure.asBinaryTagHolder(tag)))));
    }
}

