/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.merchant;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.item.MerchantOffer;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.merchant.TradeOffer;
import org.spongepowered.common.accessor.item.MerchantOfferAccessor;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.Constants;

public class SpongeTradeOfferBuilder
extends AbstractDataBuilder<TradeOffer>
implements TradeOffer.Builder,
DataBuilder<TradeOffer> {
    private ItemStackSnapshot firstItem = ItemStackSnapshot.empty();
    @Nullable
    private ItemStackSnapshot secondItem;
    private ItemStackSnapshot sellingItem = ItemStackSnapshot.empty();
    private int useCount;
    private int maxUses;
    private boolean allowsExperience;
    private int merchantExperienceGranted;
    private double priceGrowthMultiplier;
    private int demandBonus;

    public SpongeTradeOfferBuilder() {
        super(TradeOffer.class, 1);
        this.reset();
    }

    @Override
    public TradeOffer.Builder firstBuyingItem(ItemStack item) {
        Preconditions.checkNotNull((Object)item, (Object)"Buying item cannot be null");
        this.firstItem = item.createSnapshot();
        return this;
    }

    @Override
    public TradeOffer.Builder secondBuyingItem(ItemStack item) {
        this.secondItem = item != null ? item.createSnapshot() : ItemStackSnapshot.empty();
        return this;
    }

    @Override
    public TradeOffer.Builder sellingItem(ItemStack item) {
        this.sellingItem = item.createSnapshot();
        return this;
    }

    @Override
    public TradeOffer.Builder uses(int uses) {
        Preconditions.checkArgument((uses >= 0 ? 1 : 0) != 0, (Object)"Usage count cannot be negative");
        this.useCount = uses;
        return this;
    }

    @Override
    public TradeOffer.Builder maxUses(int maxUses) {
        Preconditions.checkArgument((maxUses > 0 ? 1 : 0) != 0, (Object)"Max usage count must be greater than 0");
        this.maxUses = maxUses;
        return this;
    }

    @Override
    public TradeOffer.Builder canGrantExperience(boolean experience) {
        this.allowsExperience = experience;
        return this;
    }

    @Override
    public TradeOffer.Builder merchantExperienceGranted(int experience) {
        this.merchantExperienceGranted = experience;
        return this;
    }

    @Override
    public TradeOffer.Builder priceGrowthMultiplier(double priceGrowthMultiplier) {
        this.priceGrowthMultiplier = priceGrowthMultiplier;
        return this;
    }

    @Override
    public TradeOffer.Builder demandBonus(int bonus) {
        this.demandBonus = bonus;
        return this;
    }

    @Override
    public TradeOffer build() throws IllegalStateException {
        Preconditions.checkState((this.firstItem != null ? 1 : 0) != 0, (Object)"Trading item has not been set");
        Preconditions.checkState((this.sellingItem != null ? 1 : 0) != 0, (Object)"Selling item has not been set");
        Preconditions.checkState((this.useCount <= this.maxUses ? 1 : 0) != 0, (String)"Usage count cannot be greater than the max usage count (%s)", (int)this.maxUses);
        ItemStack first = this.firstItem.createStack();
        ItemStack second = this.secondItem == null ? null : this.secondItem.createStack();
        ItemStack selling = this.sellingItem.createStack();
        MerchantOffer merchantOffer = new MerchantOffer(ItemStackUtil.toNative(first), ItemStackUtil.toNative(second), ItemStackUtil.toNative(selling), this.useCount, this.maxUses, this.merchantExperienceGranted, (float)this.priceGrowthMultiplier);
        ((MerchantOfferAccessor)merchantOffer).accessor$setRewardsExp(this.allowsExperience);
        ((MerchantOfferAccessor)merchantOffer).accessor$setDemand(this.demandBonus);
        return (TradeOffer)merchantOffer;
    }

    @Override
    public TradeOffer.Builder from(TradeOffer offer) {
        Preconditions.checkNotNull((Object)offer, (Object)"Trade offer cannot be null");
        this.firstItem = offer.getFirstBuyingItem();
        this.secondItem = offer.getSecondBuyingItem().orElse(null);
        this.sellingItem = offer.getSellingItem();
        this.useCount = offer.getUses();
        this.maxUses = offer.getMaxUses();
        this.allowsExperience = offer.doesGrantExperience();
        this.merchantExperienceGranted = offer.getExperienceGrantedToMerchant();
        this.priceGrowthMultiplier = offer.getPriceGrowthMultiplier();
        this.demandBonus = offer.getDemandBonus();
        return this;
    }

    @Override
    public SpongeTradeOfferBuilder reset() {
        this.firstItem = ItemStackSnapshot.empty();
        this.secondItem = null;
        this.sellingItem = ItemStackSnapshot.empty();
        this.useCount = 0;
        this.maxUses = 7;
        this.allowsExperience = true;
        this.merchantExperienceGranted = 0;
        this.priceGrowthMultiplier = 0.0;
        this.demandBonus = 0;
        return this;
    }

    @Override
    protected Optional<TradeOffer> buildContent(DataView container) throws InvalidDataException {
        ItemStack secondItem;
        boolean secondPresent;
        if (!container.contains(Constants.Item.TradeOffer.FIRST_QUERY, Constants.Item.TradeOffer.SECOND_QUERY, Constants.Item.TradeOffer.EXPERIENCE_QUERY, Constants.Item.TradeOffer.MAX_QUERY, Constants.Item.TradeOffer.USES_QUERY, Constants.Item.TradeOffer.BUYING_QUERY)) {
            return Optional.empty();
        }
        ItemStack firstItem = container.getSerializable(Constants.Item.TradeOffer.FIRST_QUERY, ItemStack.class).get();
        ItemStack buyingItem = container.getSerializable(Constants.Item.TradeOffer.BUYING_QUERY, ItemStack.class).get();
        if (container.getString(Constants.Item.TradeOffer.SECOND_QUERY).isPresent() && container.getString(Constants.Item.TradeOffer.SECOND_QUERY).get().equals("none")) {
            secondPresent = false;
            secondItem = null;
        } else {
            secondPresent = true;
            secondItem = container.getSerializable(Constants.Item.TradeOffer.SECOND_QUERY, ItemStack.class).get();
        }
        SpongeTradeOfferBuilder builder = new SpongeTradeOfferBuilder();
        builder.firstBuyingItem(firstItem);
        if (secondPresent) {
            builder.secondBuyingItem(secondItem);
        }
        builder.sellingItem(buyingItem).maxUses(container.getInt(Constants.Item.TradeOffer.MAX_QUERY).get()).uses(container.getInt(Constants.Item.TradeOffer.USES_QUERY).get()).canGrantExperience(container.getBoolean(Constants.Item.TradeOffer.EXPERIENCE_QUERY).get()).merchantExperienceGranted(container.getInt(Constants.Item.TradeOffer.EXPERIENCE_GRANTED_TO_MERCHANT_QUERY).orElse(0)).priceGrowthMultiplier(container.getDouble(Constants.Item.TradeOffer.PRICE_GROWTH_MULTIPLIER_QUERY).orElse(0.0)).demandBonus(container.getInt(Constants.Item.TradeOffer.DEMAND_BONUS_QUERY).orElse(0));
        return Optional.of(builder.build());
    }
}

