/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.merchant;

import com.google.common.base.Preconditions;
import java.util.Random;
import javax.annotation.Nullable;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackGenerator;
import org.spongepowered.api.item.merchant.Merchant;
import org.spongepowered.api.item.merchant.TradeOffer;
import org.spongepowered.api.item.merchant.TradeOfferGenerator;
import org.spongepowered.api.util.weighted.VariableAmount;

public final class SpongeTradeOfferGenerator
implements TradeOfferGenerator {
    final ItemStackGenerator firstItemGenerator;
    final ItemStackGenerator sellingItemGenerator;
    @Nullable
    final ItemStackGenerator secondItemGenerator;
    final double experience;
    final VariableAmount baseUses;
    final VariableAmount maxUses;

    public static Builder builder() {
        return new Builder();
    }

    SpongeTradeOfferGenerator(Builder builder) {
        this.firstItemGenerator = builder.firstGenerator;
        this.secondItemGenerator = builder.secondGenerator;
        this.sellingItemGenerator = builder.sellingGenerator;
        this.experience = builder.experience;
        this.baseUses = builder.baseUses;
        this.maxUses = builder.maxUses;
    }

    @Override
    public TradeOffer apply(Random random, Merchant merchant) {
        Preconditions.checkNotNull((Object)random, (Object)"Random cannot be null!");
        TradeOffer.Builder builder = TradeOffer.builder();
        builder.firstBuyingItem((ItemStack)this.firstItemGenerator.apply(random));
        if (this.secondItemGenerator != null) {
            builder.secondBuyingItem((ItemStack)this.secondItemGenerator.apply(random));
        }
        builder.sellingItem((ItemStack)this.sellingItemGenerator.apply(random));
        builder.canGrantExperience(random.nextDouble() < this.experience);
        builder.uses(this.baseUses.getFlooredAmount(random));
        builder.maxUses(this.maxUses.getFlooredAmount(random));
        return builder.build();
    }

    public static final class Builder
    implements TradeOfferGenerator.Builder {
        ItemStackGenerator firstGenerator;
        @Nullable
        ItemStackGenerator secondGenerator;
        ItemStackGenerator sellingGenerator;
        double experience;
        VariableAmount baseUses;
        VariableAmount maxUses;

        @Override
        public TradeOfferGenerator.Builder setPrimaryItemGenerator(ItemStackGenerator generator) {
            this.firstGenerator = (ItemStackGenerator)Preconditions.checkNotNull((Object)generator, (Object)"ItemStackGenerator cannot be null!");
            return this;
        }

        @Override
        public TradeOfferGenerator.Builder setSecondItemGenerator(@Nullable ItemStackGenerator generator) {
            this.secondGenerator = generator;
            return this;
        }

        @Override
        public TradeOfferGenerator.Builder setSellingGenerator(ItemStackGenerator sellingGenerator) {
            this.sellingGenerator = (ItemStackGenerator)Preconditions.checkNotNull((Object)sellingGenerator, (Object)"ItemStackGenerator cannot be null!");
            return this;
        }

        @Override
        public TradeOfferGenerator.Builder experienceChance(double experience) {
            this.experience = experience;
            return this;
        }

        @Override
        public TradeOfferGenerator.Builder startingUses(VariableAmount amount) {
            this.baseUses = (VariableAmount)Preconditions.checkNotNull((Object)amount, (Object)"Variable amount cannot be null!");
            return this;
        }

        @Override
        public TradeOfferGenerator.Builder maxUses(VariableAmount amount) {
            this.maxUses = (VariableAmount)Preconditions.checkNotNull((Object)amount, (Object)"Variable amount cannot be null!");
            return this;
        }

        @Override
        public TradeOfferGenerator build() {
            Preconditions.checkState((this.firstGenerator != null ? 1 : 0) != 0, (Object)"First item populators cannot be empty! Populate with some BiConsumers!");
            Preconditions.checkState((this.sellingGenerator != null ? 1 : 0) != 0, (Object)"Selling item populators cannot be empty! Populate with some BiConsumers!");
            Preconditions.checkState((this.baseUses != null ? 1 : 0) != 0);
            Preconditions.checkState((this.maxUses != null ? 1 : 0) != 0);
            return new SpongeTradeOfferGenerator(this);
        }

        @Override
        public TradeOfferGenerator.Builder from(TradeOfferGenerator value) {
            this.reset();
            if (value instanceof SpongeTradeOfferGenerator) {
                SpongeTradeOfferGenerator generator = (SpongeTradeOfferGenerator)value;
                this.firstGenerator = generator.firstItemGenerator;
                this.secondGenerator = generator.secondItemGenerator;
                this.sellingGenerator = generator.sellingItemGenerator;
                this.experience = generator.experience;
                this.baseUses = generator.baseUses;
                this.maxUses = generator.maxUses;
                return this;
            }
            throw new IllegalArgumentException("The provided TradeOfferGenerator is incompatible with the current implementation!");
        }

        @Override
        public TradeOfferGenerator.Builder reset() {
            this.firstGenerator = null;
            this.secondGenerator = null;
            this.sellingGenerator = null;
            this.experience = 0.5;
            this.baseUses = null;
            this.maxUses = null;
            return this;
        }
    }
}

